package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import caslayout.codegen.struts.StrutsCodeGenerator;
import caslayout.codegen.struts.StrutsCodeGeneratorException;
import caslayout.codegen.struts.StrutsCodegenConfig;
import caslayout.ui.CALMHelper;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.Document;
import caslayout.ui.MinimumCodeGenInfoDlg;
import caslayout.ui.StrutsCodeGenParamsDialog;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StrutsCodeGenAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class StrutsCodeGenAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = -7855191434380410734L;

	public StrutsCodeGenAdapter(ClinicalAssessmentLayoutManager manager, String text, ImageIcon icon, String desc,
			Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		StrutsCodegenConfig config = manager.getSavedState().getStrutsConfig();
		Document doc = ClinicalAssessmentLayoutManager.getCurDoc();

		MinimumCodeGenInfoDlg mDlg = new MinimumCodeGenInfoDlg(
				manager,
				"Mandatory Information for Struts Code Generation", config,
				doc);
		int rc = mDlg.showDialog();
		if (rc != BaseDialog.OK_PRESSED) {
			mDlg.dispose();
			return;
		} else {
			mDlg.dispose();
		}

		// at this point the config object is fully populated

		StrutsCodeGenParamsDialog dlg = new StrutsCodeGenParamsDialog(
				manager,"Struts Code Generator Properties", config, doc);
		rc = dlg.showDialog();
		if (rc == BaseDialog.OK_PRESSED) {
			StrutsCodeGenerator generator = new StrutsCodeGenerator(config,
					doc);
			try {
				/*
				 * The Xforms and XSL based JSP generation is not further
				 * developed as of 11/17/2004, instead the JSPs are directly
				 * generated (IBO)
				 * 
				 * generator.generateXForms();
				 * generator.generateStyleSheet();
				 * generator.doXSLTransform();
				 */
				generator.generateFormBean();
				generator.generateJSPs();
				generator.generateTilesJspPages();
				generator.updateStrutsConfigFile();
				generator.integrateWithWebApp();
				JOptionPane.showMessageDialog(
						this.manager,
						"Code generation is completed successfully!",
						"Code Generation", JOptionPane.INFORMATION_MESSAGE);

				dlg.dispose();		
			} catch (StrutsCodeGeneratorException x) {
				ClinicalAssessmentLayoutManager.getLog().error("", x);
				CALMHelper.showError(this.manager, x.getMessage(),
						"An error occured during Code Generation");
			}
		}
	}
}