package caslayout.ui.assoc;

import guilib.common.BaseDialog;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;

import org.apache.log4j.Logger;

import caslayout.ui.AbstractDisplayComponent;
import caslayout.ui.CAContainer;
import caslayout.ui.CheckBoxDisplayComponent;
import caslayout.ui.IDisplayComponent;
import caslayout.ui.LogicalGroup;
import caslayout.ui.RadioButtonDisplayComponent;
import caslayout.ui.SelectedComponentInfo;
import caslayout.ui.TextAreaDisplayComponent;
import caslayout.ui.TextDisplayComponent;
import caslayout.ui.TextFieldDisplayComponent;
import caslayout.ui.model.AssessmentInfo;
import caslayout.ui.model.MandatoryFieldAssociation;
import caslayout.ui.model.ScoreAssociation;
import caslayout.ui.model.ScoreCodeInfo;
import caslayout.ui.model.ScoreInfo;
import caslayout.ui.model.SecurityClassificationInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssociationDialog.java,v 1.13 2008/10/13 23:58:07 bozyurt Exp $
 */

public class AssociationDialog extends BaseDialog {
   private static final long serialVersionUID = 6711331703025210924L;
   protected JPanel mainPanel;
   protected ScoreInfo scoreInfo;
   protected String mandatoryField;
   protected JLabel assocLabel;
   protected JComboBox secClassCombo;
   protected CAContainer selectedContainer;
   /** a single selected component */
   protected AbstractDisplayComponent selectedField;
   protected LinkedHashMap<String, AbstractDisplayComponent> compMap = new LinkedHashMap<String, AbstractDisplayComponent>();
   protected JTable ascTable;
   protected JPanel controlPanel;
   protected SelectedComponentInfo selectedComp;
   protected ScoreAssociation scoreAssoc;
   protected MandatoryFieldAssociation mfa;
   protected boolean hasScoreCodePanel = false;
   protected static Logger log = Logger.getLogger(AssociationDialog.class);

   public AssociationDialog(Frame owner, String title, ScoreInfo scoreInfo,
         SelectedComponentInfo selectedComp, ScoreAssociation sa) {
      super(owner, title, new String[] { "Cancel", "OK" });
      setDefaultButton("Cancel");
      this.selectedComp = selectedComp;
      this.scoreInfo = scoreInfo;
      this.scoreAssoc = sa;

      init(true);
      if (hasScoreCodePanel) {
         setSize(new Dimension(450, 480));
      } else {
         pack();
      }
   }

   public AssociationDialog(Frame owner, String title, String mandatoryField,
         SelectedComponentInfo selectedComp, MandatoryFieldAssociation mfa) {
      super(owner, title, new String[] { "Cancel", "OK" });
      setDefaultButton("Cancel");
      this.mandatoryField = mandatoryField;
      this.selectedComp = selectedComp;
      this.mfa = mfa;
      init(false);
      if (hasScoreCodePanel) {
         setSize(new Dimension(450, 480));
      } else {
         pack();
      }
   }

   protected void init(boolean forScoreInfo) {
      mainPanel = new JPanel(new BorderLayout(5, 5));
      mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
      hasScoreCodePanel = false;
      if (forScoreInfo) {
         initForScoreInfo();
      } else {
         initForMandatoryField();
      }
      mainPanel.add(controlPanel, BorderLayout.CENTER);
      getContentPane().add(mainPanel);
   }

   protected void initForScoreInfo() {
      LogicalGroup logicalGroup = selectedComp.findLogicalGroup();

      JPanel scoreCodeAssocPanel = null;
      this.controlPanel = new JPanel(new BorderLayout(5, 5));

      controlPanel.setBorder(BorderFactory.createTitledBorder("Association"));
      assocLabel = new JLabel("Score " + scoreInfo.getScoreName()
            + " is not associated");

      if (scoreAssoc != null) {
         assocLabel.setText("Score " + scoreInfo.getScoreName()
               + " is associated with component " + scoreAssoc.getRHSID());

      }

      List<SecurityClassificationInfo> secClassList = AssessmentInfo
            .getSecurityClassifications();

      String[] scList = new String[secClassList.size()];
      int i = 0;
      int selIdx = 0;
      for (Iterator<SecurityClassificationInfo> iter = secClassList.iterator(); iter
            .hasNext();) {
         SecurityClassificationInfo sci = iter.next();
         scList[i] = sci.getSecurityClassification();
         if (scList[i].equals(scoreInfo.getSecurityClassification())) {
            selIdx = i;
         }
         i++;
      }
      secClassCombo = new JComboBox(scList);
      JPanel cp = new JPanel();
      BoxLayout bl = new BoxLayout(cp, BoxLayout.X_AXIS);
      cp.setLayout(bl);
      cp.add(new JLabel("Security Classification:"));
      cp.add(Box.createHorizontalGlue());
      cp.add(secClassCombo);
      secClassCombo.setSelectedIndex(selIdx);

      JPanel panel1 = new JPanel(new GridLayout(2, 1, 5, 5));
      panel1.add(assocLabel);

      panel1.add(cp);
      controlPanel.add(panel1, BorderLayout.NORTH);

      if (!scoreInfo.getScoreCodes().isEmpty() && logicalGroup != null) {
         // show the score code association panel
         scoreCodeAssocPanel = createScoreCodePanel(logicalGroup);
         controlPanel.add(scoreCodeAssocPanel, BorderLayout.SOUTH);
         hasScoreCodePanel = true;
      }

      if (scoreCodeAssocPanel != null) {
         controlPanel.add(scoreCodeAssocPanel);
      }
   }

   protected void initForMandatoryField() {
      this.controlPanel = new JPanel(new BorderLayout(5, 5));
      controlPanel.setBorder(BorderFactory.createTitledBorder("Association"));

      assocLabel = new JLabel("Mandatory Field '" + mandatoryField
            + " is not associated");
      if (mfa != null) {
         assocLabel.setText("Mandatory Field '" + mandatoryField
               + " is associated with component " + mfa.getRight().getId());
      }
      controlPanel.add(assocLabel, BorderLayout.NORTH);
   }

   protected void prepareScoreValueComponents(DefaultMutableTreeNode node,
         LinkedHashMap<String, AbstractDisplayComponent> itemMap) {
      FormNodeInfo ni = (FormNodeInfo) node.getUserObject();
      AbstractDisplayComponent adc = (AbstractDisplayComponent) ni.getData();
      if (adc instanceof CAContainer) {
         CAContainer c = (CAContainer) adc;
         if (c.getIsGroup()) {
            for (int i = 0; i < node.getChildCount(); i++) {
               DefaultMutableTreeNode child = (DefaultMutableTreeNode) node
                     .getChildAt(i);
               prepareScoreValueComponents(child, itemMap);
            }
         }
      } else {
         itemMap.put(ni.getLabel(), adc);
      }
   }

   protected void prepareScoreValueComponents(LogicalGroup logicalGroup,
         LinkedHashMap<String, AbstractDisplayComponent> itemMap) {
      List<IDisplayComponent> dispCompList = logicalGroup.getElements();
      int idx = 0;
      for (Iterator<IDisplayComponent> iter = dispCompList.iterator(); iter
            .hasNext();) {
         AbstractDisplayComponent adc = (AbstractDisplayComponent) iter.next();

         itemMap.put(prepareDisplayComponentLabel(adc, idx, itemMap), adc);
         ++idx;
      }
   }

   protected String prepareDisplayComponentLabel(AbstractDisplayComponent adc,
         int idx, Map<String, AbstractDisplayComponent> itemMap) {
      String label = null;

      if (adc instanceof TextDisplayComponent) {
         label = ((TextDisplayComponent) adc).getLabel().getText();
      } else if (adc instanceof TextFieldDisplayComponent) {
         label = "Edit Field";
         if (itemMap.get(label) != null) {
            label += " - " + String.valueOf(idx);
         }
      } else if (adc instanceof TextAreaDisplayComponent) {
         label = "Textarea Field";
         if (itemMap.get(label) != null) {
            label += " - " + String.valueOf(idx);
         }
      } else if (adc instanceof RadioButtonDisplayComponent) {
         RadioButtonDisplayComponent r = (RadioButtonDisplayComponent) adc;
         label = "Radio Button - ";
         if (r.getText() != null && r.getText().trim().length() > 0) {
            label += r.getText();
            if (itemMap.get(label) != null) {
               label += "Radio Button - " + String.valueOf(idx);
            }
         } else {
            label += String.valueOf(idx);
         }
      } else if (adc instanceof CheckBoxDisplayComponent) {
         CheckBoxDisplayComponent c = (CheckBoxDisplayComponent) adc;
         label = "Check Box - ";
         if (c.getText() != null && c.getText().trim().length() > 0) {
            label += c.getText();
            if (itemMap.get(label) != null) {
               label += "Check Box - " + String.valueOf(idx);
            }
         } else {
            label += String.valueOf(idx);
         }
      }
      return label;
   }

   protected JPanel createScoreCodePanel(LogicalGroup logicalGroup) {
      JPanel panel = new JPanel(new BorderLayout(5, 5));
      List<ScoreCodeInfo> ascList = scoreInfo.getScoreCodes();

      prepareScoreValueComponents(logicalGroup, compMap);
      // use only labels
      String[] svcs = new String[compMap.size()];
      int i = 0;
      // component Map is keyed by the component label
      for (Iterator<String> iter = compMap.keySet().iterator(); iter.hasNext();) {
         String label = iter.next();
         svcs[i++] = label;
      }

      String[] curCompSelections = new String[svcs.length];
      for (i = 0; i < curCompSelections.length; i++) {
         curCompSelections[i] = svcs[i];
      }
      TableModel tm = new TableModel(ascList, curCompSelections);

      ascTable = new JTable(tm);
      ascTable.setPreferredScrollableViewportSize(new Dimension(220, 80));

      // prepare the drop down table column
      TableColumn compColumn = ascTable.getColumnModel().getColumn(0);
      JComboBox cb = new JComboBox();
      for (i = 0; i < svcs.length; i++) {
         cb.addItem(svcs[i]);
      }
      compColumn.setCellEditor(new DefaultCellEditor(cb));

      // prepare the score code value drop down column also
      TableColumn scColumn = ascTable.getColumnModel().getColumn(1);
      cb = new JComboBox();
      for (Iterator<ScoreCodeInfo> iter = ascList.iterator(); iter.hasNext();) {
         ScoreCodeInfo sci = iter.next();
         cb.addItem(sci.getScoreCodeValue());
      }
      scColumn.setCellEditor(new DefaultCellEditor(cb));

      panel.setBorder(BorderFactory
            .createTitledBorder("Associate Score Codes with GUI Components"));
      JScrollPane scrollPane = new JScrollPane(ascTable);
      panel.add(scrollPane);

      return panel;
   }

   public void actionPerformed(ActionEvent e) {
      this.returnCode = BaseDialog.NONE;
      if (e.getSource() instanceof JButton) {
         JButton button = (JButton) e.getSource();
         if (button.getText().equalsIgnoreCase("ok")) {
            this.returnCode = OK_PRESSED;
         }
      }
      setVisible(false);
   }

   public MandatoryFieldAssociation getMandatoryFieldAssociation() {
      this.mfa.setRight(selectedField);
      return mfa;
   }

   /**
    * Based on the user's selections sets score codes; namely sets the
    * corresponding value for the display component like radio button and check
    * box groups
    *
    * @return
    */
   public ScoreAssociation getScoreAssociation() {
      if (ascTable != null) {
         TableModel tm = (TableModel) ascTable.getModel();
         for (int i = 0; i < tm.data.length; i++) {
            String compLabel = (String) tm.data[i][1];
            String scoreCode = (String) tm.data[i][0];
            AbstractDisplayComponent ac = (AbstractDisplayComponent) this.compMap
                  .get(compLabel);
            ScoreCodeInfo sci = scoreInfo.findScoreCode(scoreCode);
            if (sci == null)
               continue;
            if (ac instanceof RadioButtonDisplayComponent) {
               RadioButtonDisplayComponent rdc = (RadioButtonDisplayComponent) ac;
               rdc.setValue(sci.getScoreCode());
            } else if (ac instanceof CheckBoxDisplayComponent) {
               CheckBoxDisplayComponent cdc = (CheckBoxDisplayComponent) ac;
               cdc.setValue(sci.getScoreCode());
            }
         }
      }
      return scoreAssoc;
   }

   class TableModel extends AbstractTableModel {
      private static final long serialVersionUID = -5550663800030899578L;
      private String[] columnNames;
      private Object[][] data;

      public TableModel(List<ScoreCodeInfo> sciList, String[] currentCompSelections) {
         this.columnNames = new String[] { "Associated Component",
               "Score Value" };

         int noData = Math.max(sciList.size(), currentCompSelections.length);
         data = new Object[noData][2];
         int i = 0, lastGoodIdx1 = 0, lastGoodIdx2 = 0;
         for (i = 0; i < noData; i++) {
            ScoreCodeInfo sci = null;
            String ccs = null;
            if (i < sciList.size()) {
               sci = (ScoreCodeInfo) sciList.get(i);
               lastGoodIdx1 = i;
            } else {
               sci = (ScoreCodeInfo) sciList.get(lastGoodIdx1);
            }
            if (i < currentCompSelections.length) {
               ccs = currentCompSelections[i];
               lastGoodIdx2 = i;
            } else {
               ccs = currentCompSelections[lastGoodIdx2];
            }
            data[i][1] = sci.getScoreCodeValue();
            data[i][0] = ccs;
         }
      }

      public int getRowCount() {
         return data.length;
      }

      public int getColumnCount() {
         return columnNames.length;
      }

      public Object getValueAt(int row, int col) {
         return data[row][col];
      }

      public String getColumnName(int col) {
         return columnNames[col];
      }

      public Class<?> getColumnClass(int col) {
         return getValueAt(0, col).getClass();
      }

      public boolean isCellEditable(int row, int col) {
         return true;
      }

      public void setValueAt(Object value, int row, int col) {
         data[row][col] = value;
         fireTableCellUpdated(row, col);
      }
   } // TableModel

}
