package caslayout.ui.assoc;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import caslayout.util.GUIUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DefaultNodeRenderer.java,v 1.2 2006/03/29 02:25:03 bozyurt Exp $
 */
public class DefaultNodeRenderer extends DefaultTreeCellRenderer {
	private static final long serialVersionUID = -6898570476370268292L;
	protected ImageIcon leafIcon;
	protected ImageIcon parentIcon;

	public DefaultNodeRenderer() {
		leafIcon = GUIUtils.createImageIcon("/images/child_object.gif");
		parentIcon = GUIUtils.createImageIcon("/images/parent_node.gif");
	}

	public Component getTreeCellRendererComponent(JTree tree, Object value,
			boolean sel, boolean expanded, boolean leaf, int row,
			boolean hasFocus)
	{
		super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf,
				row, hasFocus);
		if (leaf) {
			setIcon(leafIcon);
		} else {
			setIcon(parentIcon);
		}
		return this;
	}
}
