package caslayout.ui.assoc;

import caslayout.ui.AbstractDisplayComponent;
import caslayout.ui.CAContainer;
import caslayout.ui.CheckBoxDisplayComponent;
import caslayout.ui.IDisplayComponent;
import caslayout.ui.RadioButtonDisplayComponent;
import caslayout.ui.TextAreaDisplayComponent;
import caslayout.ui.TextDisplayComponent;
import caslayout.ui.TextFieldDisplayComponent;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: FormNodeInfo.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class FormNodeInfo {
   protected String label = "";
   protected IDisplayComponent data;

   public FormNodeInfo(IDisplayComponent data) {
      if (data instanceof TextDisplayComponent) {
         label = ((TextDisplayComponent) data).getLabel().getText();
      } else if (data instanceof TextFieldDisplayComponent) {
         label = "Edit Field";
      } else if (data instanceof TextAreaDisplayComponent) {
         label = "Textarea Field";
      } else if (data instanceof RadioButtonDisplayComponent) {
         RadioButtonDisplayComponent r = (RadioButtonDisplayComponent) data;
         label = "Radio Button - ";
         if (r.getText() != null && r.getText().length() > 0)
            label += r.getText();
      } else if (data instanceof CheckBoxDisplayComponent) {
         CheckBoxDisplayComponent c = (CheckBoxDisplayComponent) data;
         label = "Check Box - ";
         if (c.getText() != null && c.getText().length() > 0)
            label += c.getText();
      } else if (data instanceof CAContainer) {
         label = "Container ";
         CAContainer c = (CAContainer) data;
         if (c.getIsGroup())
            label += " <group>";
      }
      AbstractDisplayComponent adc = (AbstractDisplayComponent) data;
      label += " (" + adc.getId() + ")";
      this.data = data;
   }

   public String getLabel() {
      return this.label;
   }

   public IDisplayComponent getData() {
      return this.data;
   }

   public String toString() {
      if (label.length() > 25) {
         return label.substring(0, 25) + "...";
      }
      return label;
   }

}
