package caslayout.ui.assoc;

import guilib.common.BaseDialog;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import caslayout.exception.ValidationException;
import caslayout.ui.CALMHelper;
import caslayout.ui.model.ItemInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ItemInfoDialog.java,v 1.4 2007/10/08 18:00:41 bozyurt Exp $
 */

public class ItemInfoDialog extends BaseDialog {
	private static final long serialVersionUID = -79793526944387895L;
	protected ItemInfo itemInfo;
	protected JTextArea leadingTextField;
	protected JTextArea trailingTextField;

	public ItemInfoDialog(Frame owner, String title, ItemInfo itemInfo) {
		super(owner, title, new String[] { "Cancel",  "OK"});
		setDefaultButton("Cancel");
		this.itemInfo = itemInfo;
		init();
		setSize(600, 400);
	}

	protected void init()
	{
		JPanel labelPanel = new JPanel(new GridLayout(2, 1, 5, 5));
		JPanel fieldPanel = new JPanel(new GridLayout(2, 1, 5, 5));

		leadingTextField = new JTextArea(3, 40);
		trailingTextField = new JTextArea(3, 40);

		labelPanel.add(new JLabel("Leading Text:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Trailing Text:", JLabel.RIGHT));

		fieldPanel.add(new JScrollPane(leadingTextField));
		if (itemInfo.getItemLeadingText() != null)
			leadingTextField.setText(itemInfo.getItemLeadingText());
		fieldPanel.add(new JScrollPane(trailingTextField));

		JPanel mainPanel = new JPanel();
		BoxLayout bl = new BoxLayout(mainPanel, BoxLayout.X_AXIS);
		mainPanel.setLayout(bl);
		mainPanel.setBorder(BorderFactory.createCompoundBorder(
				BorderFactory.createEmptyBorder(5, 5, 5, 5),
				BorderFactory.createTitledBorder("Assessment Item for "
						+ itemInfo.getScoreName()))  );
		mainPanel.add(labelPanel);
		mainPanel.add(fieldPanel);
		getContentPane().add(mainPanel);
	}

	protected void updateItemInfoFromUserInput() throws ValidationException
	{
		if (leadingTextField.getText().trim().length() == 0)
			throw new ValidationException("Leading Text cannot be empty!");
		itemInfo.setItemLeadingText(leadingTextField.getText().trim());

		if (trailingTextField.getText().trim().length() > 0) {
			itemInfo.setItemTrailingText(trailingTextField.getText().trim());
		}
	}

	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = BaseDialog.NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				try {
					updateItemInfoFromUserInput();
				} catch (ValidationException ve) {
					CALMHelper.showError(this, ve.getMessage(),	"Validation Error");
					return;
				}
				this.returnCode = OK_PRESSED;
			}
		}
		setVisible(false);
	}

}