package caslayout.ui.assoc;

import java.util.*;
import java.util.List;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import caslayout.exception.*;
import caslayout.ui.CALMHelper;
import caslayout.ui.model.*;
import guilib.common.*;

/**
 *
 * @todo needs to be able to delete score codes also
 *
 * @author I. Burak Ozyurt
 * @version $Id: ScoreCodeDialog.java,v 1.7 2008/10/13 23:58:07 bozyurt Exp $
 */

public class ScoreCodeDialog extends BaseDialog {
   private static final long serialVersionUID = -2929613057028537796L;
   protected ScoreInfo scoreInfo;
   protected List<ScoreCodeInfo> scoreCodes;
   protected JTable scoreCodeTable;
   protected JButton addCodeButton;
   protected JButton removeCodeButton;
   protected TableModel tableModel;

   public ScoreCodeDialog(Frame owner, String title, ScoreInfo scoreInfo) {
      super(owner, title, new String[] { "Cancel", "OK" });
      setDefaultButton("Cancel");
      this.scoreInfo = scoreInfo;
      scoreCodes = new ArrayList<ScoreCodeInfo>();
      init();
      setSize(new Dimension(400, 400));
   }

   protected void init() {
      JPanel staticPanel = new JPanel(new GridLayout(2, 2, 4, 4));
      staticPanel.add(new JLabel("Assessment:", JLabel.RIGHT));
      staticPanel.add(new JLabel(scoreInfo.getAssessment().getName(),
            JLabel.LEFT));
      staticPanel.add(new JLabel("Score:", JLabel.RIGHT));
      staticPanel.add(new JLabel(scoreInfo.getScoreName(), JLabel.LEFT));

      JPanel tablePanel = new JPanel(new BorderLayout(3, 3));
      tablePanel.setBorder(BorderFactory
            .createTitledBorder("Create Score Codes"));
      tableModel = new TableModel();
      scoreCodeTable = new JTable(tableModel);
      scoreCodeTable.setPreferredScrollableViewportSize(new Dimension(220, 80));
      tablePanel.add(new JScrollPane(scoreCodeTable));
      addCodeButton = new JButton("Add Score Code");
      addCodeButton.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
            handleScoreAddition();
         }
      });
      removeCodeButton = new JButton("Remove Score Code");
      removeCodeButton.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
            handleScoreDeletion();
         }
      });

      // populate the table with the current score codes
      if (scoreInfo.getScoreCodes() != null) {
         for (Iterator<ScoreCodeInfo> iter = scoreInfo.getScoreCodes()
               .iterator(); iter.hasNext();) {
            ScoreCodeInfo sci = iter.next();
            this.scoreCodes.add(sci);
            tableModel.addRow(sci);
         }
      }

      JPanel buttonPanel = new JPanel();
      BoxLayout bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS);
      buttonPanel.setLayout(bl);
      buttonPanel.add(addCodeButton);
      buttonPanel.add(Box.createHorizontalGlue());
      buttonPanel.add(removeCodeButton);

      tablePanel.add(buttonPanel, BorderLayout.NORTH);

      JPanel mainPanel = new JPanel(new BorderLayout(3, 3));
      mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

      mainPanel.add(staticPanel, BorderLayout.NORTH);
      mainPanel.add(tablePanel);

      getContentPane().add(mainPanel);
   }

   protected void handleScoreAddition() {
      ScoreCodeInfo sci = new ScoreCodeInfo(scoreInfo.getScoreName(), "", "",
            scoreInfo.getScoreType(), scoreInfo.getScoreTypeFormat());
      scoreCodes.add(sci);
      tableModel.addRow(sci);
   }

   protected void handleScoreDeletion() {
      int selRow = scoreCodeTable.getSelectedRow();
      if (selRow == -1)
         return;
      String[] rowData = tableModel.removeRow(selRow);
      for (Iterator<ScoreCodeInfo> iter = scoreCodes.iterator(); iter.hasNext();) {
         ScoreCodeInfo sci = (ScoreCodeInfo) iter.next();
         if (sci.getScoreCode().equals(rowData[0])) {
            iter.remove();
            break;
         }
      }
   }

   protected void updateScoreCodesFromUserInput() throws ValidationException {
      int rows = tableModel.getRowCount();
      Iterator<ScoreCodeInfo> iter = scoreCodes.iterator();
      for (int i = 0; i < rows; i++) {
         ScoreCodeInfo sci = (ScoreCodeInfo) iter.next();

         String sc = (String) tableModel.getValueAt(i, 0);
         if (sc.trim().length() == 0) {
            throw new ValidationException("The score code row " + (i + 1)
                  + " cannot be empty!");
         }
         String scValue = (String) tableModel.getValueAt(i, 1);
         if (scValue.trim().length() == 0) {
            throw new ValidationException("The score code value at row "
                  + (i + 1) + " cannot be empty!");
         }
         sci.setScoreCode(sc);
         sci.setScoreCodeValue(scValue);
      }
   }

   public List<ScoreCodeInfo> getScoreCodes() {
      return scoreCodes;
   }

   public void actionPerformed(ActionEvent e) {
      this.returnCode = BaseDialog.NONE;
      if (e.getSource() instanceof JButton) {
         JButton button = (JButton) e.getSource();
         if (button.getText().equalsIgnoreCase("ok")) {
            try {
               updateScoreCodesFromUserInput();
            } catch (ValidationException ve) {
               CALMHelper.showError(this, ve.getMessage(), "Validation Error");
               return;
            }
            this.returnCode = OK_PRESSED;
         }
      }
      setVisible(false);
   }

   class TableModel extends AbstractTableModel {
      private static final long serialVersionUID = -8318174178037833281L;
      private String[] columnNames;
      private List<String[]> data = new ArrayList<String[]>();

      public TableModel() {
         this.columnNames = new String[] { "Score Code", "Score Code Value" };
      }

      public int getRowCount() {
         return data.size();
      }

      public int getColumnCount() {
         return columnNames.length;
      }

      public Object getValueAt(int row, int col) {
         String[] tableRow = (String[]) data.get(row);
         return tableRow[col];
      }

      public String getColumnName(int col) {
         return columnNames[col];
      }

      public Class<?> getColumnClass(int col) {
         return getValueAt(0, col).getClass();
      }

      public boolean isCellEditable(int row, int col) {
         return true;
      }

      public void setValueAt(Object value, int row, int col) {
         String[] tableRow = (String[]) data.get(row);
         tableRow[col] = value.toString();
         fireTableCellUpdated(row, col);
      }

      public void addRow(ScoreCodeInfo sci) {
         String[] newRow = new String[2];
         newRow[0] = sci.getScoreCode();
         newRow[1] = sci.getScoreCodeValue();
         data.add(newRow);
         fireTableDataChanged();
      }

      public String[] removeRow(int rowIdx) {
         String[] rowData = (String[]) data.remove(rowIdx);
         fireTableDataChanged();
         return rowData;
      }
   }
}
