package caslayout.ui.assoc;

import caslayout.ui.model.*;

/**
 * A wrapper class encapsulating the selected model ( data) component,
 * which can be either a score or a mandatory field like date the assessment is done
 * etc).
 *
 * @author I. Burak Ozyurt
 * @version $Id: SelectedModelDataInfo.java,v 1.1 2004/07/29 02:08:53 bozyurt Exp $
 */
public class SelectedModelDataInfo {
  protected ScoreInfo scoreInfo;
  protected NodeInfo mandatoryField;


  public SelectedModelDataInfo(ScoreInfo si) {
    this.scoreInfo = si;
  }

  public SelectedModelDataInfo(NodeInfo mandatoryField) {
    this.mandatoryField = mandatoryField;
  }

  public boolean hasScoreInfo() { return scoreInfo != null; }
  public boolean hasMandatoryField() { return mandatoryField != null; }


  public ScoreInfo getScoreInfo() { return this.scoreInfo; }
  public NodeInfo getMandatoryField() { return this.mandatoryField; }

}