package caslayout.ui.builder;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AnswerGroup.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class AnswerGroup {
   protected String dataType;
   protected String compType;
   protected List<Answer> answers = new ArrayList<Answer>(4);
   protected Location loc;
   protected Orientation orientation;
   protected SubQuestion owner;

   public AnswerGroup(Location loc, Orientation orient, String compType,
         String dataType, SubQuestion owner) {
      this.loc = loc;
      this.orientation = orient;
      this.compType = compType;
      this.dataType = dataType;
      this.owner = owner;
   }

   public void addAnswer(Answer answer) {
      answers.add(answer);
   }

   public List<Answer> getAnswers() {
      return answers;
   }

   public boolean isMultipleSelection() {
      return answers.size() > 1;
   }

   public String getCompType() {
      return compType;
   }

   public String getDataType() {
      return dataType;
   }

   public Location getLoc() {
      return loc;
   }

   public Orientation getOrientation() {
      return orientation;
   }

   public void setLoc(Location loc) {
      this.loc = loc;
   }

   public void setOrientation(Orientation orientation) {
      this.orientation = orientation;
   }

   public SubQuestion getOwner() {
      return owner;
   }

}
