package caslayout.ui.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Assessment.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class Assessment {
   protected String name;
   protected String label;
   protected List<Page> pages = new ArrayList<Page>(2);

   public Assessment(String name, String label) {
      super();
      this.name = name;
      if (label == null) {
         this.label = name;
      } else {
         this.label = label;
      }
   }

   public void addPage(Page p) {
      pages.add(p);
   }

   public int getNumQuestions() {
      int sum = 0;
      for (Iterator<Page> iter = pages.iterator(); iter.hasNext();) {
         Page p = iter.next();
         sum += p.getQuestions().size();
      }
      return sum;
   }

   public String getLabel() {
      return label;
   }

   public String getName() {
      return name;
   }

   public List<Page> getPages() {
      return pages;
   }

}
