package caslayout.ui.builder;

import java.util.LinkedHashMap;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ComponentConfig.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class ComponentConfig implements BuilderConstants {
   protected String id;
   protected String justification;
   protected String cssClass;
   protected int fieldLength = DEFAULT_FIELD_LENGTH;
   protected int maxFieldLength = DEFAULT_MAX_FIELD_LENGTH;
   protected int numCols = DEFAULT_NUM_COLS;
   protected int numRows = DEFAULT_NUM_ROWS;

   protected LinkedHashMap<String, String> labelValueMap;

   public ComponentConfig(String id) {
      this(id, null, null);
   }

   public ComponentConfig(String id, String justification) {
      this(id, justification, null);
   }

   public ComponentConfig(String id, String justification, String cssClass) {
      super();
      this.id = id;
      this.justification = justification;
      this.cssClass = cssClass;
   }

   public void addLabelValue(String label, String value) {
      if (labelValueMap == null) {
         labelValueMap = new LinkedHashMap<String, String>(17);
      }
      labelValueMap.put(label, value);
   }

   public ComponentConfig() {
      super();
   }

   public String getCssClass() {
      return cssClass;
   }

   public String getId() {
      return id;
   }

   public String getJustification() {
      return justification;
   }

   public LinkedHashMap<String, String> getLabelValueMap() {
      return labelValueMap;
   }

   public int getFieldLength() {
      return fieldLength;
   }

   public int getMaxFieldLength() {
      return maxFieldLength;
   }

   public int getNumCols() {
      return numCols;
   }

   public int getNumRows() {
      return numRows;
   }

   public void setFieldLength(int fieldLength) {
      this.fieldLength = fieldLength;
   }

   public void setMaxFieldLength(int maxFieldLength) {
      this.maxFieldLength = maxFieldLength;
   }

   public void setNumCols(int numCols) {
      this.numCols = numCols;
   }

   public void setNumRows(int numRows) {
      this.numRows = numRows;
   }

}
