package caslayout.ui.builder;

import java.io.Serializable;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Location.java,v 1.2 2007/10/08 18:09:37 bozyurt Exp $
 */
public class Location implements Serializable {
	protected String code;

	private static final long serialVersionUID = 1L;
	public final static Location NORTH = new Location("North");
	public final static Location SOUTH = new Location("South");
	public final static Location EAST = new Location("East");
	public final static Location WEST = new Location("West");
	public final static Location CENTER = new Location("Center");

	public Location(String code) {
		this.code = code;
	}

	public static Location find(String locCode) {
		if (locCode.equalsIgnoreCase(EAST.code)) {
			return EAST;
		} else if (locCode.equalsIgnoreCase(WEST.code)) {
			return WEST;
		} else if (locCode.equalsIgnoreCase(NORTH.code)) {
			return NORTH;
		} else if (locCode.equalsIgnoreCase(SOUTH.code)) {
			return SOUTH;
		} else if (locCode.equalsIgnoreCase(CENTER.code)) {
			return CENTER;
		}
		return null;
	}

	public String toString() {
		return code;
	}
}// ;
