package caslayout.ui.builder;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: MultiScoreQuestion.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class MultiScoreQuestion implements IQuestion {
   protected String id;
   protected List<SubQuestion> subQuestions = new ArrayList<SubQuestion>(5);
   protected String textBefore;
   protected String textAfter;
   protected int minAnswer = 1;
   protected int maxAnswer = 5;

   protected int type;

   public final static int SINGLE_ANSWER = 1;
   public final static int MULTIPLE_ANSWER = 2;

   public MultiScoreQuestion(String id) {
      this.id = id;
      this.type = MULTIPLE_ANSWER;
   }

   public void addSubQuestion(SubQuestion sq) {
      subQuestions.add(sq);
   }

   public String getId() {
      return id;
   }

   public int getMaxAnswer() {
      return maxAnswer;
   }

   public int getMinAnswer() {
      return minAnswer;
   }

   public List<SubQuestion> getSubQuestions() {
      return subQuestions;
   }

   public String getTextAfter() {
      return textAfter;
   }

   public String getTextBefore() {
      return textBefore;
   }

   public int getType() {
      return type;
   }

   public void setMaxAnswer(int maxAnswer) {
      this.maxAnswer = maxAnswer;
   }

   public void setMinAnswer(int minAnswer) {
      this.minAnswer = minAnswer;
   }

   public void setTextAfter(String textAfter) {
      this.textAfter = textAfter;
   }

   public void setTextBefore(String textBefore) {
      this.textBefore = textBefore;
   }

   public int getOrderIndex() {
      if (id.startsWith("q")) {
         return Integer.parseInt(id.substring(1));
      } else {
         return Integer.parseInt(id);
      }
   }
}
