package caslayout.ui.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Page.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class Page {
   protected int number;
   protected String title;
   protected List<IQuestion> questions = new ArrayList<IQuestion>(10);
   protected List<SkipAction> skipActions = new ArrayList<SkipAction>(1);

   public Page(int number, String title) {
      this.number = number;
      this.title = title;
   }

   public void addQuestion(IQuestion q) {
      questions.add(q);
   }

   public void addSkipAction(SkipAction sa) {
      skipActions.add(sa);
   }

   public int getNumber() {
      return number;
   }

   public List<IQuestion> getQuestions() {
      return questions;
   }

   public String getTitle() {
      return title;
   }

   public List<SkipAction> getSkipActions() {
      return skipActions;
   }

   public SkipAction getSkipActionAfter(IQuestion q) {
      if (skipActions.isEmpty()) {
         return null;
      }
      for (Iterator<SkipAction> iter = skipActions.iterator(); iter.hasNext();) {
         SkipAction sa = iter.next();
         if (sa.getAfterQuestionId().equals(q.getId())) {
            return sa;
         }
      }
      return null;
   }

}
