package caslayout.ui.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import caslayout.util.GenUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SkipAction.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */

public class SkipAction {
	protected boolean javaScriptOnly = false;
	protected String buttonLabel;
	protected List<Integer> questionIdList2Skip;
	/** the id of the question after which this skip action will be inserted */
	protected String afterQuestionId;

	public SkipAction(String afterQuestionId, boolean javaScriptOnly, String buttonLabel) {
		super();
		this.afterQuestionId = afterQuestionId;
		this.javaScriptOnly = javaScriptOnly;
		this.buttonLabel = buttonLabel;
	}

	public void prepareQuestionIdList(String expression) throws Exception {
		questionIdList2Skip = new ArrayList<Integer>();
		String[] tokens = expression.split("\\s*,\\s*");
		Set<Integer> uniqSet = new HashSet<Integer>();
		for (int i = 0; i < tokens.length; i++) {
			int idx = tokens[i].indexOf('-');
			if (idx != -1) {
				String[] bounds = tokens[i].split("\\s*-\\s*");
				int lowBound = GenUtils.toInt(bounds[0], -1);
				int uppBound = GenUtils.toInt(bounds[1], -1);
				if ( uppBound == -1 || lowBound == -1) {
					throw new Exception("Not a valid range!:" + tokens[i]);
				}
				if (uppBound != -1 && lowBound != -1 && lowBound < uppBound) {
					for (int j = lowBound; j <= uppBound; j++) {
						Integer qid = new Integer(j);
						if (!uniqSet.contains(qid)) {
							questionIdList2Skip.add(qid);
							uniqSet.add(qid);
						}
					}
				}

			} else {
				try {
				Integer qid = new Integer(tokens[i]);
				if (!uniqSet.contains(qid)) {
					questionIdList2Skip.add(qid);
					uniqSet.add(qid);
				}
				} catch(Throwable t) {
					throw new Exception(t);
				}
			}
		}
		Collections.sort(questionIdList2Skip);
	}

	public String getQuestionIdsAsCSV() {
		StringBuffer buf = new StringBuffer();
		for (Iterator<Integer> iter = questionIdList2Skip.iterator(); iter.hasNext();) {
			Integer qid = iter.next();
			// since internal representation of question ids start from 0
			buf.append(qid.intValue() -1 );
			if ( iter.hasNext()) buf.append(',');
		}
		return buf.toString();
	}

	public String getAfterQuestionId() {
		return afterQuestionId;
	}

	public boolean isJavaScriptOnly() {
		return javaScriptOnly;
	}

	public List<Integer> getQuestionIdList2Skip() {
		return questionIdList2Skip;
	}

	public String getButtonLabel() {
		return buttonLabel;
	}

}
