package caslayout.ui.builder;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubQuestion.java,v 1.2 2007/10/08 18:09:37 bozyurt Exp $
 */
public class SubQuestion {
	protected String id;
	
	protected String bindingScore;
	protected String scoreType;
	protected String scoreTypeFormat;
	/** one based */
	protected Integer scoreSequence;
	protected String securityClass = "FIRST BIRN";
	
	protected String textBefore;
	protected String textAfter;
	protected AnswerGroup answerGroup;
	protected int type;
	
	public final static int SINGLE_ANSWER = 1;
	public final static int MULTIPLE_ANSWER = 2;
	
	
	public SubQuestion(String bindingScore, String scoreType) {
		this.bindingScore = bindingScore;
		this.scoreType = scoreType;
		this.type = SINGLE_ANSWER;
	}
	
	
	public String getId()
	{
		return id;
	}

	public int getType()
	{
		return type;
	}

	
	public AnswerGroup getAnswerGroup()
	{
		return answerGroup;
	}

	public String getBindingScore()
	{
		return bindingScore;
	}

	
	public String getTextAfter()
	{
		return textAfter;
	}

	public String getTextBefore()
	{
		return textBefore;
	}

	
	public void setAnswerGroup(AnswerGroup answerGroup)
	{
		this.answerGroup = answerGroup;
	}

	public void setTextAfter(String textAfter)
	{
		this.textAfter = textAfter;
	}

	public void setTextBefore(String textBefore)
	{
		this.textBefore = textBefore;
	}

	public Integer getScoreSequence()
	{
		return scoreSequence;
	}

	public String getScoreType()
	{
		return scoreType;
	}

	public String getSecurityClass()
	{
		return securityClass;
	}

	public void setScoreSequence(Integer scoreSequence)
	{
		this.scoreSequence = scoreSequence;
	}

	public void setScoreType(String scoreType)
	{
		this.scoreType = scoreType;
	}

	public void setSecurityClass(String securityClass)
	{
		this.securityClass = securityClass;
	}

	public String getScoreTypeFormat() {
		return scoreTypeFormat;
	}

	public void setScoreTypeFormat(String scoreTypeFormat) {
		this.scoreTypeFormat = scoreTypeFormat;
	}

	
	public int getOrderIndex() {
		if ( id.startsWith("q")) {
			return Integer.parseInt( id.substring(1));
		} else {
			return Integer.parseInt( id );
		}
	}

}
