package caslayout.ui.calc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;

import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.Document;
import caslayout.ui.IDisplayComponent;
import caslayout.ui.LogicalGroup;
import caslayout.ui.model.AssessmentAssociation;
import caslayout.ui.model.AssessmentInfo;
import caslayout.ui.model.AssociationHelper;
import caslayout.ui.model.ScoreAssociation;
import caslayout.ui.model.ScoreInfo;
import caslayout.util.GUIUtils;
import caslayout.util.GenUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AsScoreTreePanel.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class AsScoreTreePanel extends JPanel {
	private static final long serialVersionUID = 6293243227752900702L;
	protected JTree tree;
	protected DefaultTreeModel treeModel;
	protected DefaultMutableTreeNode modelRoot;
	protected AssociationHelper assocHelper;
	protected String calcScoreName;

	public AsScoreTreePanel(AssociationHelper assocHelper, String scoreName) {
		super();
		this.assocHelper = assocHelper;
		this.calcScoreName = scoreName;
		this.setLayout(new BorderLayout(3, 3));
		init();
	}

	protected void init() {
		prepareTree();
		JScrollPane sp = new JScrollPane(tree);
		sp.setBorder(BorderFactory.createTitledBorder("Scores for calculation"));
		sp.setPreferredSize( new Dimension(0,100));
		this.add(sp);
	}

	protected void prepareTree() {
		modelRoot = new DefaultMutableTreeNode("Available Scores");

		if ( this.calcScoreName != null) {
			int curPageIdx = findPageForCalcScore();

			AssessmentAssociation aa = assocHelper.getAsAssoc();
			AssessmentInfo asi = aa.getLeft();
			for (Object element : asi.getScores()) {
				ScoreInfo si = (ScoreInfo) element;
				if ( !si.getScoreType().equalsIgnoreCase("integer") &&
						!si.getScoreType().equalsIgnoreCase("float")  )
				{
					continue;
				}
				ScoreAssociation sa = assocHelper.findScoreAssociation(si);
				if ( sa != null && !si.getScoreName().equals(calcScoreName) ) {
					// check if the score is in the same page as the calculated score
					if (onTheSamePage(si, sa, curPageIdx) ) {
						String varName = GenUtils.convertToJavaVariableName(si.getScoreName());
						DefaultMutableTreeNode node = new DefaultMutableTreeNode(varName);
						modelRoot.add(node);
					}
				}
			}
		}
	    tree = new JTree(modelRoot);
	    tree.setDragEnabled(true);
	    tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
	    tree.setCellRenderer( new VarNodeRenderer() );
	}

	private int findPageForCalcScore() {
		AssessmentAssociation aa = assocHelper.getAsAssoc();
	    AssessmentInfo asi = aa.getLeft();
		for (Object element : asi.getScores()) {
		      ScoreInfo si = (ScoreInfo) element;
		      if (si.getScoreName().equals(this.calcScoreName)) {
		    	  Document curDoc = ClinicalAssessmentLayoutManager.getCurDoc();
		    	  ScoreAssociation sa = assocHelper.findScoreAssociation(si);
		    	  IDisplayComponent idc = (IDisplayComponent) sa.getRight();
		    	  return curDoc.findPageForDisplayComponent(idc);
		      }
		}
		return -1;
	}

	private boolean onTheSamePage(ScoreInfo si, ScoreAssociation sa, int curPageIdx) {
		Document curDoc = ClinicalAssessmentLayoutManager.getCurDoc();
		IDisplayComponent idc = null;
		if (sa.getRight() instanceof IDisplayComponent) {
			idc = (IDisplayComponent) sa.getRight();
		} else {
			LogicalGroup lg = (LogicalGroup) sa.getRight();
			if (lg.getElements().size() >= 1) {
				idc = (IDisplayComponent) lg.getElements().get(0);
			}
		}
		if (idc == null) {
			return false;
		}
		int pageIdx = curDoc.findPageForDisplayComponent(idc);
		return (curPageIdx == pageIdx);
	}


	public static class VarNodeRenderer extends DefaultTreeCellRenderer {
		private static final long serialVersionUID = 8945750154414295224L;
		private ImageIcon leafIcon;
		private ImageIcon parentIcon;

		public VarNodeRenderer() {
			leafIcon = GUIUtils.createImageIcon("/images/child_object.gif");
			parentIcon = GUIUtils.createImageIcon("/images/parent_node.gif");
		}

		public Component getTreeCellRendererComponent(JTree tree, Object value,
				boolean sel, boolean expanded, boolean leaf, int row,
				boolean hasFocus)
		{
			Component c = super.getTreeCellRendererComponent(tree, value, sel,
					expanded, leaf, row, hasFocus);
			if (leaf) {
				this.setIcon(leafIcon);
			} else {
				this.setIcon(parentIcon);
			}
			return c;
		}
	}
}
