// $ANTLR 2.7.7 (20061030): "expression.g" -> "ExpressionLexer.java"$

package caslayout.ui.calc;

import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;

import antlr.ANTLRHashString;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;

public class ExpressionLexer extends antlr.CharScanner implements
      ExpressionParserTokenTypes, TokenStream {


   public ExpressionLexer(InputStream in) {
      this(new ByteBuffer(in));
   }

   public ExpressionLexer(Reader in) {
      this(new CharBuffer(in));
   }

   public ExpressionLexer(InputBuffer ib) {
      this(new LexerSharedInputState(ib));
   }

   @SuppressWarnings("unchecked")
   public ExpressionLexer(LexerSharedInputState state) {
      super(state);
      caseSensitiveLiterals = true;
      setCaseSensitive(true);
      literals = new Hashtable<ANTLRHashString, Integer>();
      literals.put(new ANTLRHashString("cos", this), new Integer(18));
      literals.put(new ANTLRHashString("exp", this), new Integer(20));
      literals.put(new ANTLRHashString("log", this), new Integer(19));
      literals.put(new ANTLRHashString("sin", this), new Integer(17));
      literals.put(new ANTLRHashString("sqrt", this), new Integer(21));
   }

   @SuppressWarnings("unused")
   public Token nextToken() throws TokenStreamException {
      Token theRetToken = null;
      tryAgain: for (;;) {
         Token _token = null;
         int _ttype = Token.INVALID_TYPE;
         resetText();
         try { // for char stream error handling
            try { // for lexical error handling
               switch (LA(1)) {
               case '+': {
                  mPLUS(true);
                  theRetToken = _returnToken;
                  break;
               }
               case '-': {
                  mMINUS(true);
                  theRetToken = _returnToken;
                  break;
               }
               case '*': {
                  mMUL(true);
                  theRetToken = _returnToken;
                  break;
               }
               case '/': {
                  mDIV(true);
                  theRetToken = _returnToken;
                  break;
               }
               case '%': {
                  mMOD(true);
                  theRetToken = _returnToken;
                  break;
               }
               case ';': {
                  mSEMI(true);
                  theRetToken = _returnToken;
                  break;
               }
               case '(': {
                  mLPAREN(true);
                  theRetToken = _returnToken;
                  break;
               }
               case ')': {
                  mRPAREN(true);
                  theRetToken = _returnToken;
                  break;
               }
               case '0':
               case '1':
               case '2':
               case '3':
               case '4':
               case '5':
               case '6':
               case '7':
               case '8':
               case '9': {
                  mNUM(true);
                  theRetToken = _returnToken;
                  break;
               }
               case 'A':
               case 'B':
               case 'C':
               case 'D':
               case 'E':
               case 'F':
               case 'G':
               case 'H':
               case 'I':
               case 'J':
               case 'K':
               case 'L':
               case 'M':
               case 'N':
               case 'O':
               case 'P':
               case 'Q':
               case 'R':
               case 'S':
               case 'T':
               case 'U':
               case 'V':
               case 'W':
               case 'X':
               case 'Y':
               case 'Z':
               case 'a':
               case 'b':
               case 'c':
               case 'd':
               case 'e':
               case 'f':
               case 'g':
               case 'h':
               case 'i':
               case 'j':
               case 'k':
               case 'l':
               case 'm':
               case 'n':
               case 'o':
               case 'p':
               case 'q':
               case 'r':
               case 's':
               case 't':
               case 'u':
               case 'v':
               case 'w':
               case 'x':
               case 'y':
               case 'z': {
                  mID(true);
                  theRetToken = _returnToken;
                  break;
               }
               case '\t':
               case '\n':
               case '\r':
               case ' ': {
                  mWS(true);
                  theRetToken = _returnToken;
                  break;
               }
               default: {
                  if (LA(1) == EOF_CHAR) {
                     uponEOF();
                     _returnToken = makeToken(Token.EOF_TYPE);
                  } else {
                     throw new NoViableAltForCharException((char) LA(1),
                           getFilename(), getLine(), getColumn());
                  }
               }
               }
               if (_returnToken == null)
                  continue tryAgain; // found SKIP token
               _ttype = _returnToken.getType();
               _ttype = testLiteralsTable(_ttype);
               _returnToken.setType(_ttype);
               return _returnToken;
            } catch (RecognitionException e) {
               throw new TokenStreamRecognitionException(e);
            }
         } catch (CharStreamException cse) {
            if (cse instanceof CharStreamIOException) {
               throw new TokenStreamIOException(
                     ((CharStreamIOException) cse).io);
            } else {
               throw new TokenStreamException(cse.getMessage());
            }
         }
      }
   }

   public final void mPLUS(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = PLUS;
      @SuppressWarnings("unused")
      int _saveIndex;

      match('+');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mMINUS(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = MINUS;
      @SuppressWarnings("unused")
      int _saveIndex;

      match('-');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mMUL(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = MUL;
      @SuppressWarnings("unused")
      int _saveIndex;

      match('*');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mDIV(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = DIV;
      @SuppressWarnings("unused")
      int _saveIndex;

      match('/');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mMOD(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = MOD;
      @SuppressWarnings("unused")
      int _saveIndex;

      match('%');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mSEMI(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = SEMI;
      @SuppressWarnings("unused")
      int _saveIndex;

      match(';');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mLPAREN(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = LPAREN;
      @SuppressWarnings("unused")
      int _saveIndex;

      match('(');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mRPAREN(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = RPAREN;
      match(')');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   protected final void mDIGIT(boolean _createToken)
         throws RecognitionException, CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = DIGIT;
      @SuppressWarnings("unused")
      int _saveIndex;

      matchRange('0', '9');
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mNUM(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = NUM;
      @SuppressWarnings("unused")
      int _saveIndex;

      {
         int _cnt32 = 0;
         _loop32: do {
            if (((LA(1) >= '0' && LA(1) <= '9'))) {
               mDIGIT(false);
            } else {
               if (_cnt32 >= 1) {
                  break _loop32;
               } else {
                  throw new NoViableAltForCharException((char) LA(1),
                        getFilename(), getLine(), getColumn());
               }
            }

            _cnt32++;
         } while (true);
      }
      {
         if ((LA(1) == '.')) {
            match('.');
            {
               _loop35: do {
                  if (((LA(1) >= '0' && LA(1) <= '9'))) {
                     mDIGIT(false);
                  } else {
                     break _loop35;
                  }

               } while (true);
            }
         } else {}

      }
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mID(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = ID;
      @SuppressWarnings("unused")
      int _saveIndex;

      {
         switch (LA(1)) {
         case 'a':
         case 'b':
         case 'c':
         case 'd':
         case 'e':
         case 'f':
         case 'g':
         case 'h':
         case 'i':
         case 'j':
         case 'k':
         case 'l':
         case 'm':
         case 'n':
         case 'o':
         case 'p':
         case 'q':
         case 'r':
         case 's':
         case 't':
         case 'u':
         case 'v':
         case 'w':
         case 'x':
         case 'y':
         case 'z': {
            matchRange('a', 'z');
            break;
         }
         case 'A':
         case 'B':
         case 'C':
         case 'D':
         case 'E':
         case 'F':
         case 'G':
         case 'H':
         case 'I':
         case 'J':
         case 'K':
         case 'L':
         case 'M':
         case 'N':
         case 'O':
         case 'P':
         case 'Q':
         case 'R':
         case 'S':
         case 'T':
         case 'U':
         case 'V':
         case 'W':
         case 'X':
         case 'Y':
         case 'Z': {
            matchRange('A', 'Z');
            break;
         }
         default: {
            throw new NoViableAltForCharException((char) LA(1), getFilename(),
                  getLine(), getColumn());
         }
         }
      }
      {
         _loop39: do {
            switch (LA(1)) {
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z': {
               matchRange('a', 'z');
               break;
            }
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'H':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z': {
               matchRange('A', 'Z');
               break;
            }
            case '_': {
               match('_');
               break;
            }
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': {
               mDIGIT(false);
               break;
            }
            default: {
               break _loop39;
            }
            }
         } while (true);
      }
      _ttype = testLiteralsTable(_ttype);
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

   public final void mWS(boolean _createToken) throws RecognitionException,
         CharStreamException, TokenStreamException {
      int _ttype;
      Token _token = null;
      int _begin = text.length();
      _ttype = WS;
      @SuppressWarnings("unused")
      int _saveIndex;

      {
         switch (LA(1)) {
         case ' ': {
            match(' ');
            break;
         }
         case '\t': {
            match('\t');
            break;
         }
         case '\r': {
            match('\r');
            match('\n');
            break;
         }
         case '\n': {
            match('\n');
            break;
         }
         default: {
            throw new NoViableAltForCharException((char) LA(1), getFilename(),
                  getLine(), getColumn());
         }
         }
      }
      _ttype = Token.SKIP;
      if (_createToken && _token == null && _ttype != Token.SKIP) {
         _token = makeToken(_ttype);
         _token.setText(new String(text.getBuffer(), _begin, text.length()
               - _begin));
      }
      _returnToken = _token;
   }

}
