package caslayout.ui.calc;

import java.awt.BorderLayout;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import caslayout.ui.Expression;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ExpressionPanel.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class ExpressionPanel extends JPanel {
	private static final long serialVersionUID = -3000338552701168028L;
	protected JTextArea exprField;
	protected JPanel statusPanel;

	public ExpressionPanel() {
		super();
		setLayout(new BorderLayout(3, 3));
		JPanel exprPanel = new JPanel(new BorderLayout(3, 3));
		exprField = new JTextArea(3, 40);
		exprField.setDragEnabled(true);
		exprPanel.setBorder(BorderFactory.createTitledBorder("Expression"));
		exprPanel.add(exprField);

		this.add(exprPanel);
	}

	public void addDocumentListener(final Expression expression) {
		DocumentListener listener = new DocumentListener() {
			public void changedUpdate(DocumentEvent de) {
			};

			public void insertUpdate(DocumentEvent de) {
				if (exprField.getText().trim().length() > 0) {
					if (expression != null) {
						expression.setExprString(exprField.getText().trim());
					}
				}
			}

			public void removeUpdate(DocumentEvent de) {
				if (exprField.getText().trim().length() > 0) {
					if (expression != null) {
						expression.setExprString(exprField.getText().trim());
					}
				}
			}
		};
		exprField.getDocument().addDocumentListener(listener);
	}

	public void setExpressionValue(String exprStr) {
		exprField.setText(exprStr);
	}

	public String getExprValue() {
		return exprField.getText();
	}

}
