// $ANTLR 2.7.7 (20061030): "expression.g" -> "ExpressionParser.java"$

package caslayout.ui.calc;

import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;

public class ExpressionParser extends antlr.LLkParser       implements ExpressionParserTokenTypes
 {

protected ExpressionParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public ExpressionParser(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected ExpressionParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public ExpressionParser(TokenStream lexer) {
  this(lexer,1);
}

public ExpressionParser(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final void imaginaryTokenDefinitions() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST imaginaryTokenDefinitions_AST = null;
		
		AST tmp14_AST = null;
		tmp14_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp14_AST);
		match(SIGN_MINUS);
		AST tmp15_AST = null;
		tmp15_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp15_AST);
		match(SIGN_PLUS);
		imaginaryTokenDefinitions_AST = (AST)currentAST.root;
		returnAST = imaginaryTokenDefinitions_AST;
	}
	
	public final void expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expr_AST = null;
		
		sumExpr();
		astFactory.addASTChild(currentAST, returnAST);
		match(SEMI);
		expr_AST = (AST)currentAST.root;
		returnAST = expr_AST;
	}
	
	public final void sumExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST sumExpr_AST = null;
		
		prodExpr();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop6:
		do {
			if ((LA(1)==PLUS||LA(1)==MINUS)) {
				{
				switch ( LA(1)) {
				case PLUS:
				{
					AST tmp17_AST = null;
					tmp17_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp17_AST);
					match(PLUS);
					break;
				}
				case MINUS:
				{
					AST tmp18_AST = null;
					tmp18_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp18_AST);
					match(MINUS);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				prodExpr();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop6;
			}
			
		} while (true);
		}
		sumExpr_AST = (AST)currentAST.root;
		returnAST = sumExpr_AST;
	}
	
	public final void prodExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST prodExpr_AST = null;
		
		powExpr();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop10:
		do {
			if (((LA(1) >= MUL && LA(1) <= MOD))) {
				{
				switch ( LA(1)) {
				case MUL:
				{
					AST tmp19_AST = null;
					tmp19_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp19_AST);
					match(MUL);
					break;
				}
				case DIV:
				{
					AST tmp20_AST = null;
					tmp20_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp20_AST);
					match(DIV);
					break;
				}
				case MOD:
				{
					AST tmp21_AST = null;
					tmp21_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp21_AST);
					match(MOD);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				powExpr();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop10;
			}
			
		} while (true);
		}
		prodExpr_AST = (AST)currentAST.root;
		returnAST = prodExpr_AST;
	}
	
	public final void powExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST powExpr_AST = null;
		
		signExpr();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case POW:
		{
			AST tmp22_AST = null;
			tmp22_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp22_AST);
			match(POW);
			signExpr();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case SEMI:
		case PLUS:
		case MINUS:
		case MUL:
		case DIV:
		case MOD:
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		powExpr_AST = (AST)currentAST.root;
		returnAST = powExpr_AST;
	}
	
	public final void signExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST signExpr_AST = null;
		Token  m = null;
		AST m_AST = null;
		Token  p = null;
		AST p_AST = null;
		
		{
		switch ( LA(1)) {
		case MINUS:
		{
			m = LT(1);
			m_AST = astFactory.create(m);
			astFactory.makeASTRoot(currentAST, m_AST);
			match(MINUS);
			m_AST.setType(SIGN_MINUS);
			break;
		}
		case PLUS:
		{
			p = LT(1);
			p_AST = astFactory.create(p);
			astFactory.makeASTRoot(currentAST, p_AST);
			match(PLUS);
			p_AST.setType(SIGN_PLUS);
			break;
		}
		case NUM:
		case ID:
		case LPAREN:
		case SIN:
		case COS:
		case LOG:
		case EXP:
		case SQRT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		atom();
		astFactory.addASTChild(currentAST, returnAST);
		signExpr_AST = (AST)currentAST.root;
		returnAST = signExpr_AST;
	}
	
	public final void atom() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST atom_AST = null;
		
		switch ( LA(1)) {
		case NUM:
		{
			AST tmp23_AST = null;
			tmp23_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp23_AST);
			match(NUM);
			atom_AST = (AST)currentAST.root;
			break;
		}
		case ID:
		{
			AST tmp24_AST = null;
			tmp24_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp24_AST);
			match(ID);
			atom_AST = (AST)currentAST.root;
			break;
		}
		case SIN:
		{
			sinFun();
			astFactory.addASTChild(currentAST, returnAST);
			atom_AST = (AST)currentAST.root;
			break;
		}
		case COS:
		{
			cosFun();
			astFactory.addASTChild(currentAST, returnAST);
			atom_AST = (AST)currentAST.root;
			break;
		}
		case LOG:
		{
			logFun();
			astFactory.addASTChild(currentAST, returnAST);
			atom_AST = (AST)currentAST.root;
			break;
		}
		case EXP:
		{
			expFun();
			astFactory.addASTChild(currentAST, returnAST);
			atom_AST = (AST)currentAST.root;
			break;
		}
		case SQRT:
		{
			sqrtFun();
			astFactory.addASTChild(currentAST, returnAST);
			atom_AST = (AST)currentAST.root;
			break;
		}
		case LPAREN:
		{
			AST tmp25_AST = null;
			tmp25_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp25_AST);
			match(LPAREN);
			sumExpr();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			atom_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = atom_AST;
	}
	
	public final void sinFun() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST sinFun_AST = null;
		
		AST tmp27_AST = null;
		tmp27_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp27_AST);
		match(SIN);
		match(LPAREN);
		sumExpr();
		astFactory.addASTChild(currentAST, returnAST);
		match(RPAREN);
		sinFun_AST = (AST)currentAST.root;
		returnAST = sinFun_AST;
	}
	
	public final void cosFun() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST cosFun_AST = null;
		
		AST tmp30_AST = null;
		tmp30_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp30_AST);
		match(COS);
		match(LPAREN);
		sumExpr();
		astFactory.addASTChild(currentAST, returnAST);
		match(RPAREN);
		cosFun_AST = (AST)currentAST.root;
		returnAST = cosFun_AST;
	}
	
	public final void logFun() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST logFun_AST = null;
		
		AST tmp33_AST = null;
		tmp33_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp33_AST);
		match(LOG);
		match(LPAREN);
		sumExpr();
		astFactory.addASTChild(currentAST, returnAST);
		match(RPAREN);
		logFun_AST = (AST)currentAST.root;
		returnAST = logFun_AST;
	}
	
	public final void expFun() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expFun_AST = null;
		
		AST tmp36_AST = null;
		tmp36_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp36_AST);
		match(EXP);
		match(LPAREN);
		sumExpr();
		astFactory.addASTChild(currentAST, returnAST);
		match(RPAREN);
		expFun_AST = (AST)currentAST.root;
		returnAST = expFun_AST;
	}
	
	public final void sqrtFun() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST sqrtFun_AST = null;
		
		AST tmp39_AST = null;
		tmp39_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp39_AST);
		match(SQRT);
		match(LPAREN);
		sumExpr();
		astFactory.addASTChild(currentAST, returnAST);
		match(RPAREN);
		sqrtFun_AST = (AST)currentAST.root;
		returnAST = sqrtFun_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"SIGN_MINUS",
		"SIGN_PLUS",
		"SEMI",
		"PLUS",
		"MINUS",
		"MUL",
		"DIV",
		"MOD",
		"POW",
		"NUM",
		"ID",
		"LPAREN",
		"RPAREN",
		"\"sin\"",
		"\"cos\"",
		"\"log\"",
		"\"exp\"",
		"\"sqrt\"",
		"DIGIT",
		"WS"
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	
	}
