package caslayout.ui.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AbstractCommonQueryHelper.java,v 1.1 2005/09/21 00:36:26
 *          bozyurt Exp $
 */
public abstract class AbstractCommonQueryHelper implements ICommonQueryHelper {
	protected AbstractCommonQueryHelper() {
	}

	public abstract int getNextSequenceNumber(Connection con)
			throws SQLException;

	public Long getDatabaseUser(Connection con, String name) throws SQLException {
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st
					.executeQuery("select uniqueid from nc_databaseuser where name='"
							+ name.toUpperCase() + "'");
			if (rs.next()) {
				return new Long( rs.getLong(1) );
			}
			rs.close();
		} finally {
			if (st != null) {
				try {
					st.close();
				} catch (Exception x) {
				}
			}
		}
		return null;
	}

	public Long getTableID(Connection con, String tableName) throws SQLException {
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st
					.executeQuery("select tableid from nc_tableid where tablename='"
							+ tableName + "'");
			if (rs.next()) {
				return new Long(rs.getLong(1) );
			}
			rs.close();
		} finally {
			if (st != null) {
				try {
					st.close();
				} catch (Exception x) {
				}
			}
		}
		return null;
	}

	public List<Integer> getStoredAssessmentIDsForAssessment(Connection con,
			Long assessmentID) throws SQLException {
		Statement st = null;
		List<Integer> asIDs = new LinkedList<Integer>();
		try {
			st = con.createStatement();
			ResultSet rs = st
					.executeQuery("select uniqueid from nc_storedassessment where assessmentid = "
							+ assessmentID);
			while (rs.next()) {
				asIDs.add(new Integer(rs.getInt(1)));
			}
			rs.close();
			return asIDs;
		} finally {
			if (st != null) {
				try {
					st.close();
				} catch (Exception x) { /* ignore */
				}
			}
		}
	}

	public int removeStoredAssessmentsForAssessment(Connection con,
			Long assessmentID) throws SQLException {
		Statement st = null;
		try {
			st = con.createStatement();
			int noAffected = st
					.executeUpdate("delete from nc_storedassessment where assessmentid = "
							+ assessmentID);
			return noAffected;
		} finally {
			if (st != null) {
				try {
					st.close();
				} catch (Exception x) { /* ignore */
				}
			}
		}
	}

	public int removeAssessmentDataValues(Connection con, String asTableName,
			Long assessmentID) throws SQLException {
		Statement st = null;
		try {
			st = con.createStatement();
			String query = prepareDeleteQuery(assessmentID, asTableName);
			int noAffected = st.executeUpdate(query);
			return noAffected;
		} finally {
			if (st != null) {
				try {
					st.close();
				} catch (Exception x) { /* ignore */
				}
			}
		}
	}

	protected String prepareDeleteQuery(Long assessmentID, String asTableName) {
		StringBuffer buf = new StringBuffer();
		buf.append("delete from ").append(asTableName).append(
				" where assessmentid =");
		buf.append(assessmentID);
		return buf.toString();
	}

}
