package caslayout.ui.db;

/**
 * @hibernate.class table="nc_animalspecies" lazy="false"
 * @author I. Burak Ozyurt
 * @version $Id: AnimalSpecies.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AnimalSpecies extends AbstractVO {
	protected Long uniqueID;
	protected String name;
	protected String strain;
	protected String latinName;
	protected String description;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence" 
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="name" length="128" not-null="true"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="strain" length="128"
	 * @return
	 */
	public String getStrain() {
		return strain;
	}

	/**
	 * @hibernate.property column="latinname" length="128"
	 * @return
	 */
	public String getLatinName() {
		return latinName;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setStrain(String strain) {
		this.strain = strain;
	}

	public void setLatinName(String latinName) {
		this.latinName = latinName;
	}

	public void setDescription(String description) {
		this.description = description;
	}
}
