package caslayout.ui.db;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * @hibernate.class table="nc_assessment"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Assessment.java,v 1.7 2008/10/13 23:58:07 bozyurt Exp $
 */
public class Assessment extends AbstractVO implements Serializable {
	private static final long serialVersionUID = 1L;
	
	protected Long ID;
	protected String name;
	protected String description;


	// newly added to the schema Sept 20
	protected Long uniqueID;
	protected Long previousAssessmentID = null;

	protected Set<AssessmentScore> scores = new LinkedHashSet<AssessmentScore>();
	protected List<AssessmentItem> items = new LinkedList<AssessmentItem>();

	public Assessment(Long ID, String name) {
		this.ID = ID;
		this.name = name;
	}
	
	public Assessment() {}

	public void setID(Long newID) {
		this.ID = newID;
	}

	public void setName(String newName) {
		this.name = newName;
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
	}

	// not persisted
	
	public void setUniqueID(Long newUniqueID) {
		this.uniqueID = newUniqueID;
	}

	public void setPreviousAssessmentID(Long newPreviousAssessmentID) {
		this.previousAssessmentID = newPreviousAssessmentID;
	}
	
	public void setScores(Set<AssessmentScore> scores) {
		this.scores = scores;
	}

	/**
	 * @hibernate.id column="assessmentid" generator-class="sequence"
	 * @return
	 */
	public Long getID() {
		return this.ID;
	}

	/**
	 * @hibernate.property column="name" length="128" 
	 * @return
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return this.description;
	}

	// not persisted
	
	/**
	 * @hibernate.property column="uniqueid"
	 * @return
	 */
	public Long getUniqueID() {
		return this.uniqueID;
	}

	/**
	 * @hibernate.property column="previousassessmentid"
	 * @return 
	 */
	public Long getPreviousAssessmentID() {
		return this.previousAssessmentID;
	}

	public void addItem(AssessmentItem item) {
		items.add(item);
	}

	public List<AssessmentItem> getItems() {
		return items;
	}

	public void addScore(AssessmentScore score) {
		if (score == null) {
			throw new IllegalArgumentException("Null Assessment Score!");
		}
		score.setAssessment(this);
		scores.add(score);
	}

	/**
	 * @hibernate.set inverse="true" lazy="true" cascade="none"
	 * @hibernate.collection-key column="assessmentid"
	 * @hibernate.collection-one-to-many class="caslayout.ui.db.AssessmentScore"
	 * @return
	 */
	public Set<AssessmentScore> getScores() {
		return scores;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Assessment ::[");
		buf.append("id=").append(ID).append(",name=").append(name);
		for (Iterator<AssessmentScore> iter = scores.iterator(); iter.hasNext();) {
			Object item = iter.next();
			buf.append("\n\t").append(item.toString());
		}
		for (Iterator<AssessmentItem> iter = items.iterator(); iter.hasNext();) {
			Object item = iter.next();
			buf.append("\n\t").append(item.toString());
		}
		buf.append(']');
		return buf.toString();
	}

}
