package caslayout.ui.db;

/**
 * 
 * @hibernate.class table="nc_assessmentboolean"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentBoolean.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AssessmentBoolean extends BaseVO {
	protected Long assessmentDataUniqueID;
	protected Boolean dataValue;
	protected Boolean dataNormValue;
	protected Long storedAssessmentID;
	protected Long uniqueID;
	
	/**
	 * @hibernate.id column="nc_assessmentdata_uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getAssessmentDataUniqueID() {
		return assessmentDataUniqueID;
	}
	
	/**
	 * @hibernate.property column="datanormvalue" 
	 * @return
	 */
	public Boolean getDataNormValue() {
		return dataNormValue;
	}
	
	/**
	 * @hibernate.property column="datavalue" 
	 * @return
	 */
	public Boolean getDataValue() {
		return dataValue;
	}
	
	/**
	 *  @hibernate.property column="storedassessmentid"  not-null="true"
	 * @return
	 */
	public Long getStoredAssessmentID() {
		return storedAssessmentID;
	}
	
	/**
	 * @hibernate.property column="uniqueid"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}
	

	
	public void setAssessmentDataUniqueID(Long assessmentDataUniqueID) {
		this.assessmentDataUniqueID = assessmentDataUniqueID;
	}
	public void setDataNormValue(Boolean dataNormValue) {
		this.dataNormValue = dataNormValue;
	}
	public void setDataValue(Boolean dataValue) {
		this.dataValue = dataValue;
	}
	public void setStoredAssessmentID(Long storedAssessmentID) {
		this.storedAssessmentID = storedAssessmentID;
	}
	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

}
