package caslayout.ui.db;

/**
 * @hibernate.class table="nc_assessmentfloat"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentFloat.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */

public class AssessmentFloat extends BaseVO {
	protected Long assessmentDataUniqueID;
	protected Float dataValue;
	protected Float dataNormValue;
	protected Long storedAssessmentID;
	protected Long uniqueID;
	
	/**
	 * @hibernate.id column="nc_assessmentdata_uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getAssessmentDataUniqueID() {
		return assessmentDataUniqueID;
	}
	
	/**
	 * @hibernate.property column="datanormvalue" 
	 * @return
	 */
	public Float getDataNormValue() {
		return dataNormValue;
	}
	
	/**
	 * @hibernate.property column="datavalue" 
	 * @return
	 */
	public Float getDataValue() {
		return dataValue;
	}
	
	/**
	 *  @hibernate.property column="storedassessmentid"  not-null="true"
	 * @return
	 */
	public Long getStoredAssessmentID() {
		return storedAssessmentID;
	}
	
	/**
	 * @hibernate.property column="uniqueid"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}
	

	
	public void setAssessmentDataUniqueID(Long assessmentDataUniqueID) {
		this.assessmentDataUniqueID = assessmentDataUniqueID;
	}
	public void setDataNormValue(Float dataNormValue) {
		this.dataNormValue = dataNormValue;
	}
	public void setDataValue(Float dataValue) {
		this.dataValue = dataValue;
	}
	public void setStoredAssessmentID(Long storedAssessmentID) {
		this.storedAssessmentID = storedAssessmentID;
	}
	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

}
