package caslayout.ui.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;

import caslayout.ui.CALMConfig;

/**
 *
 * @deprecated
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentHelper.java,v 1.27 2008/10/14 23:21:16 bozyurt Exp $
 */
public class AssessmentHelper {
   protected CALMConfig config;
   protected Connection con;
   protected String securityClassification;
   protected boolean hasDBConnection;
   protected static AssessmentHelper instance = null;
   protected static Logger log = Logger.getLogger(AssessmentHelper.class);

   protected AssessmentHelper(CALMConfig config) throws Exception {
      this.config = config;
   }

   public static synchronized AssessmentHelper getInstance(CALMConfig config)
         throws Exception {
      if (instance == null) {
         instance = new AssessmentHelper(config);
      }
      return instance;
   }

   public static synchronized AssessmentHelper getInstance() {
      return instance;
   }

   protected Connection connect() throws SQLException {
      return DriverManager.getConnection(config.getDbURL(), config.getUser(),
            config.getPwd());
   }

   public void startup() throws SQLException {
      if (con == null) {
         con = connect();
         hasDBConnection = true;
      }
   }

   public void destroy() {
      if (con != null) {
         try {
            con.close();
            con = null;
         } catch (Exception x) {}
      }
   }

   // ---------------------- setters --------------
   public void setSecurityClassification(String newSecurityClassification) {
      this.securityClassification = newSecurityClassification;
   }

   public void setHasDBConnection(boolean newHasDBConnection) {
      this.hasDBConnection = newHasDBConnection;
   }

   // ---------------------- getters --------------
   public String getSecurityClassification() {
      return this.securityClassification;
   }

   public boolean getHasDBConnection() {
      return this.hasDBConnection;
   }

   public List<String> getAllAssessments() throws Exception {
      Statement st = null;
      List<String> asNames = new ArrayList<String>();
      try {
         st = con.createStatement();
         String query = "select name from nc_assessment order by name";
         ResultSet rs = st.executeQuery(query);
         while (rs.next()) {
            asNames.add(rs.getString(1));
         }
         rs.close();
         return asNames;

      } finally {
         if (st != null) {
            try {
               st.close();
            } catch (Exception x) {}
         }
      }
   }

   public Long getAssessmentID(String name) throws Exception {
      PreparedStatement pst = null;
      try {
         pst = con
               .prepareStatement("select assessmentid from nc_assessment where name = ?");
         pst.setString(1, name);
         ResultSet rs = pst.executeQuery();
         Long asID = null;
         if (rs.next()) {
            asID = new Long(rs.getLong(1));
         }
         rs.close();
         if (asID == null) {
            throw new Exception("No record for assessment '" + name + "'!");
         }
         return asID;
      } finally {
         if (pst != null) {
            try {
               pst.close();
            } catch (Exception x) {}
         }
      }
   }

   /**
    * returns an assessment including its scores and score codes from the
    * database.
    *
    * @param name
    *           the name of the assesment
    * @return an <code>Assessment</code> object
    * @throws java.lang.Exception
    * @see caslayout.ui.db.Assessment
    */
   public Assessment getAssessment(String name) throws Exception {

      Assessment as = null;
      Statement st = null;
      try {
         st = con.createStatement();
         String query = "select assessmentid, name from nc_assessment where name LIKE '"
               + name + "%'";
         log.info("as query=" + query);
         ResultSet rs = st.executeQuery(query);
         if (rs.next()) {
            as = new Assessment(new Long(rs.getLong(1)), rs.getString(2));
         }

         rs.close();
      } finally {
         if (st != null) {
            try {
               st.close();
            } catch (Exception x) {}
         }
      }
      if (as != null) {
         List<AssessmentScore> scores = loadScores(as);
         for (Object element : scores) {
            AssessmentScore score = (AssessmentScore) element;
            as.addScore(score);
         }

         List<AssessmentItem> items = loadItems(as);
         for (Object element : items) {
            AssessmentItem item = (AssessmentItem) element;
            as.addItem(item);
         }
      }

      return as;
   }

   /**
    * checks if there is any data for this assessment, if so throws an
    * Exception.
    *
    * @param as
    *           the assessment to be deleted
    * @throws java.lang.Exception
    */
   public void deleteAssessment(Assessment as, boolean deleteDataAlso)
         throws Exception {
      // check if there is any data for this assessment, if so skip delete
      try {
         con.setAutoCommit(false);
         if (hasAssessmentData(as, con)) {
            if (!deleteDataAlso) {
               throw new Exception(
                     "You cannot delete an assessment containing data!");
            } else {
               deleteAssessmentData(as, con);
            }
         }

         // first delete all score codes
         IAssessmentScoreCodeDAO ascDAO = DAOFactory
               .createAsssessmentScoreCodeDAO(config.getDbType());
         AssessmentScoreCode ascCriteria = new AssessmentScoreCode();
         ascCriteria.setAssessmentID(as.getID());
         ascDAO.delete(con, ascCriteria);

         // then delete all assessment items
         IAssessmentItemDAO aiDAO = DAOFactory.createAsssessmentItemDAO(config
               .getDbType());
         AssessmentItem aiCriteria = new AssessmentItem(as.getID(), null);
         aiDAO.delete(con, aiCriteria);

         // then delete all scores
         IAssessmentScoreDAO asDAO = DAOFactory
               .createAsssessmentScoreDAO(config.getDbType());
         AssessmentScore asCriteria = new AssessmentScore();
         asCriteria.setAssessmentID(as.getID());
         asDAO.delete(con, asCriteria);

         // then the assessment
         IAssessmentDAO dao = DAOFactory.createAsssessmentDAO(config
               .getDbType());

         Assessment criteria = new Assessment(as.getID(), as.getName());
         dao.delete(con, criteria);

         if (!as.getScores().isEmpty()) {
            // and the ontology concept
            AssessmentScore s = (AssessmentScore) as.getScores().iterator()
                  .next();
            deleteOntologyConcept(con, s.getAssessmentOntology(), s
                  .getAssessmentConcept());
         }

         con.commit();
      } catch (Exception se) {
         con.rollback();
         throw se;
      }
   }

   protected boolean hasAssessmentData(Assessment as, Connection con)
         throws SQLException {
      StringBuffer sb = new StringBuffer();
      sb
            .append("select count(*) from nc_storedassessment where assessmentid =");
      sb.append(as.getID());
      Statement st = null;
      try {
         st = con.createStatement();
         ResultSet rs = st.executeQuery(sb.toString());
         if (rs.next()) {
            int noRecs = rs.getInt(1);
            rs.close();
            return (noRecs > 0);
         } else {
            rs.close();
         }

      } finally {
         if (st != null) {
            try {
               st.close();
            } catch (Exception x) {}
         }
      }
      return false;
   }

   protected void deleteAssessmentData(Assessment as, Connection con)
         throws SQLException {
      ICommonQueryHelper queryHelper = CommonQueryHelperFactory
            .createCommonQueryHelper(config.getDbType());
      queryHelper.removeAssessmentDataValues(con, "nc_assessmentinteger", as
            .getID());
      queryHelper.removeAssessmentDataValues(con, "nc_assessmentvarchar", as
            .getID());
      queryHelper.removeAssessmentDataValues(con, "nc_assessmentfloat", as
            .getID());
      queryHelper.removeAssessmentDataValues(con, "nc_assessmenttimestamp", as
            .getID());
      queryHelper.removeAssessmentDataValues(con, "nc_assessmentboolean", as
            .getID());
      queryHelper.removeAssessmentDataValues(con, "nc_assessmentdata", as
            .getID());
      queryHelper.removeStoredAssessmentsForAssessment(con, as.getID());
   }

   protected Map<String, AssessmentItem> toItemMap(List<AssessmentItem> items) {
      Map<String, AssessmentItem> itemsMap = new HashMap<String, AssessmentItem>();
      for (Object element : items) {
         AssessmentItem item = (AssessmentItem) element;
         itemsMap.put(item.getScoreName(), item);
      }
      return itemsMap;
   }

   protected void updateAssessmentItems(Connection con,
         List<AssessmentItem> items, Assessment as, Long userID,
         ICommonQueryHelper queryHelper) throws Exception {
      List<AssessmentItem> oldItems;
      List<AssessmentItem> newItems = new LinkedList<AssessmentItem>();
      List<AssessmentItem> removedItems = new LinkedList<AssessmentItem>();
      List<AssessmentItem> changedItems = new LinkedList<AssessmentItem>();
      Map<String, AssessmentItem> itemsMap = toItemMap(items);
      Map<String, AssessmentItem> oldItemsMap = toItemMap(items);

      IAssessmentItemDAO dao = DAOFactory.createAsssessmentItemDAO(config
            .getDbType());
      AssessmentItem criteria = null;

      criteria = new AssessmentItem(as.getID(), null);
      oldItems = dao.find(con, criteria);

      for (Object element : oldItems) {
         AssessmentItem oldItem = (AssessmentItem) element;
         AssessmentItem newItem = itemsMap.get(oldItem.getScoreName());
         if (newItem == null) {
            removedItems.add(oldItem);
         } else if (!newItem.isSame(oldItem)) {
            changedItems.add(newItem);
         }
      }

      for (Iterator<AssessmentItem> iter = items.iterator(); iter.hasNext();) {
         AssessmentItem newItem = iter.next();
         AssessmentItem oldItem = oldItemsMap.get(newItem.getScoreName());
         if (oldItem == null) {
            newItems.add(newItem);
         }
      }

      for (Iterator<AssessmentItem> iter = removedItems.iterator(); iter
            .hasNext();) {
         AssessmentItem item = iter.next();
         criteria = new AssessmentItem(item.getAssessmentID(), item
               .getScoreName());
         dao.delete(con, criteria);
      }

      for (Iterator<AssessmentItem> iter = newItems.iterator(); iter.hasNext();) {
         AssessmentItem item = iter.next();
         setItemTableColumnValues(item, queryHelper, userID, con);
         dao.insert(con, item);
      }

      for (Iterator<AssessmentItem> iter = changedItems.iterator(); iter
            .hasNext();) {
         AssessmentItem item = iter.next();
         AssessmentItem bean = new AssessmentItem(item);

         // unset the primary key, since it can not be updated
         bean.setAssessmentID(null);
         bean.setScoreName(null);

         bean.setModUser(userID);
         bean.setModTime(new java.util.Date());

         criteria = new AssessmentItem(item.getAssessmentID(), item
               .getScoreName());
         dao.update(con, bean, criteria);
      }

   }

   public void updateAssessment(Assessment as) throws Exception {
      try {
         con.setAutoCommit(false);

         IAssessmentScoreDAO asDAO = DAOFactory
               .createAsssessmentScoreDAO(config.getDbType());

         AssessmentScore asCriteria = new AssessmentScore();
         asCriteria.setAssessmentID(as.getID());
         Set<AssessmentScore> oldScores = new LinkedHashSet<AssessmentScore>(
               asDAO.find(con, asCriteria));

         // find old scoreCodes also
         AssessmentScoreCode ascCriteria = new AssessmentScoreCode();
         ascCriteria.setAssessmentID(as.getID());
         IAssessmentScoreCodeDAO ascDAO = DAOFactory
               .createAsssessmentScoreCodeDAO(config.getDbType());
         List<AssessmentScoreCode> oldScoreCodes = ascDAO
               .find(con, ascCriteria);

         ICommonQueryHelper queryHelper = CommonQueryHelperFactory
               .createCommonQueryHelper(config.getDbType());
         Long userID = queryHelper.getDatabaseUser(con, config.getUser());

         if (userID == null) {
            throw new Exception("not a valid database user:" + config.getUser());
         }

         OntologyConcept oc = checkAndInsertOntologyConcept(con, as,
               queryHelper, as.getOwner());

         List<AssessmentScore> newScores = new LinkedList<AssessmentScore>();
         List<AssessmentScore> removedScores = new LinkedList<AssessmentScore>();
         List<AssessmentScore> changedScores = new LinkedList<AssessmentScore>();

         List<AssessmentScoreCode> newScoreCodes = new LinkedList<AssessmentScoreCode>();
         List<AssessmentScoreCode> removedScoreCodes = new LinkedList<AssessmentScoreCode>();
         List<AssessmentScoreCode> changedScoreCodes = new LinkedList<AssessmentScoreCode>();
         Map<String, List<AssessmentScoreCode>> oldScoreCodeMap = groupByScoreName(oldScoreCodes);

         for (Iterator<AssessmentScore> iter = oldScores.iterator(); iter
               .hasNext();) {
            AssessmentScore oldScore = iter.next();
            AssessmentScore newScore = findScore(oldScore.getScoreName(), as
                  .getScores());
            if (newScore == null) {
               removedScores.add(oldScore);
               populateRemovedScoreCodes(oldScore, removedScoreCodes,
                     oldScoreCodeMap);
            } else {
               List<AssessmentScoreCode> oldScoreCodeList = oldScoreCodeMap
                     .get(newScore.getScoreName());
               if (oldScoreCodeList != null) {
                  populateChangedScoreCodes(newScore, oldScoreCodeList,
                        newScoreCodes, removedScoreCodes, changedScoreCodes);
               }
               if (!newScore.isSame(oldScore)) {
                  changedScores.add(newScore);
               }
            }
         }

         for (Iterator<AssessmentScore> iter = as.getScores().iterator(); iter
               .hasNext();) {
            AssessmentScore newScore = iter.next();
            AssessmentScore oldScore = findScore(newScore.getScoreName(),
                  oldScores);
            if (oldScore == null) {
               newScores.add(newScore);
            }
         }

         for (Iterator<AssessmentScore> iter = newScores.iterator(); iter
               .hasNext();) {
            AssessmentScore score = iter.next();
            if (score.getScoreCodes() == null) {
               continue;
            }
            for (Object element : score.getScoreCodes()) {
               AssessmentScoreCode asc = (AssessmentScoreCode) element;
               newScoreCodes.add(asc);
            }
         }

         for (Iterator<AssessmentScoreCode> iter = removedScoreCodes.iterator(); iter
               .hasNext();) {
            AssessmentScoreCode asc = iter.next();
            ascCriteria = new AssessmentScoreCode();
            ascCriteria.setAssessmentID(asc.getAssessmentID());
            ascCriteria.setScoreName(asc.getScoreName());
            ascDAO.delete(con, ascCriteria);
         }

         for (Iterator<AssessmentScore> iter = removedScores.iterator(); iter
               .hasNext();) {
            AssessmentScore s = iter.next();
            asCriteria = new AssessmentScore(s.getAssessmentID(), s
                  .getScoreName());
            asDAO.delete(con, asCriteria);
         }

         for (Iterator<AssessmentScore> iter = changedScores.iterator(); iter
               .hasNext();) {
            AssessmentScore updatedScore = iter.next();
            AssessmentScore bean = new AssessmentScore(updatedScore);
            // unset primary key fields for update
            bean.setAssessmentID(null);
            bean.setScoreName(null);

            bean.setModUser(userID);
            bean.setModTime(new java.util.Date());

            asCriteria = new AssessmentScore(updatedScore.getAssessmentID(),
                  updatedScore.getScoreName());
            asDAO.update(con, bean, asCriteria);
         }

         for (Iterator<AssessmentScore> iter = newScores.iterator(); iter
               .hasNext();) {
            AssessmentScore score = iter.next();
            setScoreTableColumValues(score, queryHelper, userID, con, oc);
            asDAO.insert(con, score);
         }

         // new scorecodes for already existing scores and new scores
         for (Iterator<AssessmentScoreCode> iter = newScoreCodes.iterator(); iter
               .hasNext();) {
            AssessmentScoreCode asc = iter.next();
            setScoreCodeTableColumnValues(asc, queryHelper, userID, con);
            ascDAO.insert(con, asc);
         }

         // update the changed score codes
         for (Iterator<AssessmentScoreCode> iter = changedScoreCodes.iterator(); iter
               .hasNext();) {
            AssessmentScoreCode asc = iter.next();
            AssessmentScoreCode bean = new AssessmentScoreCode(asc);
            // unset primary key fields for update
            bean.setAssessmentID(null);
            bean.setScoreName(null);
            bean.setScoreCode(null);

            bean.setModUser(userID);
            bean.setModTime(new java.util.Date());
            ascCriteria = new AssessmentScoreCode();
            ascCriteria.setAssessmentID(asc.getAssessmentID());
            ascCriteria.setScoreName(asc.getScoreName());
            ascCriteria.setScoreCode(asc.getScoreCode());

            ascDAO.update(con, bean, ascCriteria);
         }

         // update assessment items
         updateAssessmentItems(con, as.getItems(), as, userID, queryHelper);

         con.commit();
      } catch (Exception se) {
         con.rollback();
         throw se;
      }
   }

   protected void populateRemovedScoreCodes(AssessmentScore score,
         List<AssessmentScoreCode> removedScoreCodes,
         Map<String, List<AssessmentScoreCode>> oldScoreCodeMap) {
      List<AssessmentScoreCode> scoreCodeList = oldScoreCodeMap.get(score
            .getScoreName());
      if (scoreCodeList != null) {
         removedScoreCodes.addAll(scoreCodeList);
      }
   }

   protected void populateChangedScoreCodes(AssessmentScore score,
         List<AssessmentScoreCode> oldScoreCodes,
         List<AssessmentScoreCode> newScoreCodes,
         List<AssessmentScoreCode> removedScoreCodes,
         List<AssessmentScoreCode> changedScoreCodes) throws Exception {
      List<AssessmentScoreCode> scoreCodeList = score.getScoreCodes();
      if (scoreCodeList == null) {
         return;
      }
      for (Iterator<AssessmentScoreCode> iter = scoreCodeList.iterator(); iter
            .hasNext();) {
         AssessmentScoreCode asc = iter.next();
         AssessmentScoreCode oldAsc = findScoreCode(oldScoreCodes, asc
               .getScoreCode());
         if (oldAsc == null) {
            newScoreCodes.add(asc);
         } else if (!asc.isSame(oldAsc)) {
            changedScoreCodes.add(asc);
         }
      }
      for (Iterator<AssessmentScoreCode> iter = oldScoreCodes.iterator(); iter
            .hasNext();) {
         AssessmentScoreCode oldAsc = iter.next();
         if (findScoreCode(scoreCodeList, oldAsc.getScoreCode()) == null) {
            removedScoreCodes.add(oldAsc);
         }
      }
   }

   public AssessmentScoreCode findScoreCode(
         List<AssessmentScoreCode> scoreCodes, String scoreCode) {
      for (Iterator<AssessmentScoreCode> iter = scoreCodes.iterator(); iter
            .hasNext();) {
         AssessmentScoreCode asc = iter.next();
         if (asc.getScoreCode().equals(scoreCode)) {
            return asc;
         }
      }
      return null;
   }

   protected void setItemTableColumnValues(AssessmentItem ai,
         ICommonQueryHelper queryHelper, Long userID, Connection con)
         throws Exception {
      Long tableID = queryHelper.getTableID(con, "NC_ASSESSMENTITEM");
      ai.setTableID(tableID);
      ai.setOwner(userID);
      ai.setModUser(userID);
      ai.setModTime(new java.util.Date());

      ai.setUniqueID(new Long(queryHelper.getNextSequenceNumber(con)));
   }

   protected void setScoreCodeTableColumnValues(AssessmentScoreCode asc,
         ICommonQueryHelper queryHelper, Long userID, Connection con)
         throws Exception {
      Long tableID = queryHelper.getTableID(con, "NC_ASSESSMENTSCORECODE");
      asc.setTableID(tableID);
      asc.setOwner(userID);
      asc.setModUser(userID);
      asc.setModTime(new java.util.Date());

      asc.setUniqueID(new Long(queryHelper.getNextSequenceNumber(con)));
   }

   protected void setScoreTableColumValues(AssessmentScore score,
         ICommonQueryHelper queryHelper, Long userID, Connection con,
         OntologyConcept oc) throws Exception {
      Long tableID = queryHelper.getTableID(con, "NC_ASSESSMENTSCORE");
      score.setTableID(tableID);

      score.setOwner(userID);
      score.setModUser(userID);
      score.setModTime(new java.util.Date());

      score.setAssessmentOntology(oc.getOntologySource());
      score.setAssessmentConcept(oc.getConceptID());

      score.setUniqueID(new Long(queryHelper.getNextSequenceNumber(con)));
   }

   protected AssessmentScore findScore(String scoreName,
         Set<AssessmentScore> scores) {
      for (Iterator<AssessmentScore> iter = scores.iterator(); iter.hasNext();) {
         AssessmentScore s = iter.next();
         if (s.getScoreName().equals(scoreName)) {
            return s;
         }
      }
      return null;
   }

   protected OntologyConcept checkAndInsertOntologyConcept(Connection con,
         Assessment as, ICommonQueryHelper queryHelper, Long userID)
         throws Exception {
      IOntologyConceptDAO dao = DAOFactory.createOntologyConceptDAO(config
            .getDbType());

      OntologyConcept oc = new OntologyConcept();
      oc.setOntologySource("UMLS");
      oc.setConcept(as.getName());
      log.info("looking for ontology concept with ontology source 'UMLS'");
      List<OntologyConcept> ocList = dao.find(con, oc);
      log.info("found ontology concepts size:" + ocList.size());

      if (ocList.isEmpty()) {
         Long tableID = queryHelper.getTableID(con, "NC_ONTOLOGYCONCEPT");
         oc
               .setConceptID(String.valueOf(queryHelper
                     .getNextSequenceNumber(con)));
         oc.setUniqueID(new Long(queryHelper.getNextSequenceNumber(con)));
         oc.setTableID(tableID);
         oc.setModUser(userID);
         oc.setOwner(userID);
         oc.setModTime(new java.util.Date());
         log.info("inserting ontology concept " + oc.getConcept());
         dao.insert(con, oc);
         log.info("inserted ontology concept " + oc.getConcept());
         return oc;
      } else {
         return ocList.get(0);
      }
   }

   protected void deleteOntologyConcept(Connection con, String ontologySource,
         String ontologyConcept) throws Exception {
      IOntologyConceptDAO dao = DAOFactory.createOntologyConceptDAO(config
            .getDbType());

      OntologyConcept oc = new OntologyConcept();
      oc.setConcept(ontologyConcept);
      oc.setOntologySource(ontologySource);

      dao.delete(con, oc);
   }

   public void updateAssessmentItems(Assessment as) throws Exception {
      // save assessment items
      try {
         con.setAutoCommit(false);

         ICommonQueryHelper queryHelper = CommonQueryHelperFactory
               .createCommonQueryHelper(config.getDbType());
         Long userID = queryHelper.getDatabaseUser(con, config.getUser());

         IAssessmentItemDAO aiDAO = DAOFactory.createAsssessmentItemDAO(config
               .getDbType());

         List<AssessmentItem> dbAiList = aiDAO.find(con, new AssessmentItem(as
               .getID(), null));
         Map<String, AssessmentItem> dbAIMap = new HashMap<String, AssessmentItem>();
         Map<String, AssessmentItem> aiMap = new HashMap<String, AssessmentItem>();
         for (Object element : dbAiList) {
            AssessmentItem dbAi = (AssessmentItem) element;
            dbAIMap.put(dbAi.getScoreName(), dbAi);
         }

         for (Object element : as.getItems()) {
            AssessmentItem ai = (AssessmentItem) element;
            aiMap.put(ai.getScoreName(), ai);
         }

         for (Object element : as.getItems()) {
            AssessmentItem item = (AssessmentItem) element;
            AssessmentItem dbAI = dbAIMap.get(item.getScoreName());
            if (dbAI == null) {
               setItemTableColumnValues(item, queryHelper, userID, con);
               item.setAssessmentID(as.getID());
               log.info(item.toString());
               aiDAO.insert(con, item);
            } else {
               if (!dbAI.getItemLeadingText().equals(item.getItemLeadingText())) {
                  // needs update
                  AssessmentItem bean = new AssessmentItem();
                  bean.setItemLeadingText(item.getItemLeadingText());
                  log.info("updating " + item);
                  aiDAO.update(con, bean, new AssessmentItem(as.getID(), item
                        .getScoreName()));
               }
            }
         }// iter

         for (Object element : dbAiList) {
            AssessmentItem dbAi = (AssessmentItem) element;
            if (aiMap.get(dbAi.getScoreName()) == null) {
               // remove it
               log.info("deleting " + dbAi);
               aiDAO.delete(con, new AssessmentItem(as.getID(), dbAi
                     .getScoreName()));
            }
         }

         con.commit();
      } catch (Exception se) {
         con.rollback();
         throw se;
      }

   }

   public void saveAssessment(Assessment as) throws Exception {
      Set<AssessmentScore> scores = as.getScores();
      try {
         con.setAutoCommit(false);

         IAssessmentDAO dao = DAOFactory.createAsssessmentDAO(config
               .getDbType());

         ICommonQueryHelper queryHelper = CommonQueryHelperFactory
               .createCommonQueryHelper(config.getDbType());

         Assessment criteria = new Assessment(as.getID(), as.getName());
         List<Assessment> asList = dao.find(con, criteria);

         int uniqueAsID = -1;
         if (asList.isEmpty()) {
            as.setTableID(queryHelper.getTableID(con, "NC_ASSESSMENT"));
            Long userID = queryHelper.getDatabaseUser(con, config.getUser());
            if (userID == null) {
               throw new Exception("not a valid database user:"
                     + config.getUser());
            }

            as.setOwner(userID);
            as.setModUser(userID);
            as.setModTime(new java.util.Date());
            uniqueAsID = queryHelper.getNextSequenceNumber(con);
            as.setID(new Long(uniqueAsID));
            log.info("saving assessment...");
            dao.insert(con, as);

            log.info("Checking and inserting ontology concept record...");
            OntologyConcept oc = checkAndInsertOntologyConcept(con, as,
                  queryHelper, userID);

            IAssessmentScoreDAO asDAO = DAOFactory
                  .createAsssessmentScoreDAO(config.getDbType());
            log.info("saving scores...");

            // save only the scores
            for (Object element : scores) {
               AssessmentScore score = (AssessmentScore) element;

               /** @todo scoreLevel and score must be set before */
               if (score.getTableID() == null) {
                  setScoreTableColumValues(score, queryHelper, userID, con, oc);
               }

               // update the assessment ids (since the actual id not known
               // till this point
               score.setAssessmentID(as.getID());
               if (score.getParentScore() != null) {
                  score.setParentAsID(as.getID());
               }
               score.setDescription("");
               score.setMinAnswers(new Integer(1));
               score.setMaxAnswers(new Integer(1));
               log.info("inserting score " + score.toString());
               asDAO.insert(con, score);
            }

            // save assessment items
            IAssessmentItemDAO aiDAO = DAOFactory
                  .createAsssessmentItemDAO(config.getDbType());
            for (Object element : as.getItems()) {
               AssessmentItem item = (AssessmentItem) element;
               setItemTableColumnValues(item, queryHelper, userID, con);
               item.setAssessmentID(new Long(uniqueAsID));
               log.info(item.toString());
               aiDAO.insert(con, item);
            }
            log.info("saving score codes...");
            // save the score codes also
            IAssessmentScoreCodeDAO ascDAO = DAOFactory
                  .createAsssessmentScoreCodeDAO(config.getDbType());
            for (Object element : scores) {
               AssessmentScore score = (AssessmentScore) element;
               if (score.getScoreCodes() == null) {
                  continue;
               }
               for (Object element2 : score.getScoreCodes()) {
                  AssessmentScoreCode asc = (AssessmentScoreCode) element2;
                  /** @todo how to set the scorecode label */
                  // set the scorecode label from scorecode value
                  asc.setScoreCodeLabel(asc.getScoreCodeValue());
                  log.info("inserting " + asc.toString());
                  setScoreCodeTableColumnValues(asc, queryHelper, userID, con);
                  asc.setAssessmentID(new Long(uniqueAsID));
                  ascDAO.insert(con, asc);
               }
            }

            con.commit();
         }

      } catch (Exception se) {
         con.rollback();
         throw se;
      }
   }

   public List<AssessmentItem> loadItems(Assessment as) throws Exception {
      log.info("loading assessment items");
      List<AssessmentItem> items = new LinkedList<AssessmentItem>();
      IAssessmentItemDAO aiDAO = DAOFactory.createAsssessmentItemDAO(config
            .getDbType());

      AssessmentItem criteria = new AssessmentItem(as.getID(), null);
      items = aiDAO.find(con, criteria);
      log.info("loaded assessment items");
      return items;
   }

   public List<AssessmentScore> loadScores(Assessment as) throws Exception {
      List<AssessmentScore> scores = new LinkedList<AssessmentScore>();

      IAssessmentScoreDAO dao = DAOFactory.createAsssessmentScoreDAO(config
            .getDbType());

      AssessmentScore criteria = new AssessmentScore();
      criteria.setAssessmentID(as.getID());
      scores = dao.find(con, criteria);

      List<AssessmentScoreCode> scoreCodes = loadScoreCodes(as);
      // arrange the scorecodes by the score and associate them with the users
      Map<String, List<AssessmentScoreCode>> scoreCodeMap = groupByScoreName(scoreCodes);
      for (Iterator<AssessmentScore> iter = scores.iterator(); iter.hasNext();) {
         AssessmentScore score = iter.next();
         List<AssessmentScoreCode> codeList = scoreCodeMap.get(score
               .getScoreName());
         if (codeList == null) {
            continue;
         }
         for (Object element : codeList) {
            AssessmentScoreCode asc = (AssessmentScoreCode) element;
            score.addScoreCode(asc);
         }
      }
      return scores;
   }

   public static Map<String, List<AssessmentScoreCode>> groupByScoreName(
         List<AssessmentScoreCode> scoreCodes) {
      Map<String, List<AssessmentScoreCode>> map = new HashMap<String, List<AssessmentScoreCode>>();
      for (Iterator<AssessmentScoreCode> iter = scoreCodes.iterator(); iter
            .hasNext();) {
         AssessmentScoreCode asc = iter.next();
         List<AssessmentScoreCode> codeList = map.get(asc.getScoreName());
         if (codeList == null) {
            codeList = new LinkedList<AssessmentScoreCode>();
            map.put(asc.getScoreName(), codeList);
         }
         codeList.add(asc);
      }
      return map;
   }

   public List<AssessmentScoreCode> loadScoreCodes(Assessment as)
         throws SQLException {
      List<AssessmentScoreCode> scoreCodes = new LinkedList<AssessmentScoreCode>();
      Statement st = null;
      StringBuffer sb = new StringBuffer(128);
      sb
            .append("select assessmentid, scorename, scorecode, scorecodevalue, scorecodetype from nc_assessmentscorecode");
      sb.append(" where assessmentid = ").append(as.getID());
      try {
         log.info("score code query=" + sb.toString());
         st = con.createStatement();
         ResultSet rs = st.executeQuery(sb.toString());
         while (rs.next()) {
            AssessmentScoreCode asc = new AssessmentScoreCode(new Long(rs
                  .getInt(1)), rs.getString(2), rs.getString(3), rs
                  .getString(4), rs.getString(5), "");
            scoreCodes.add(asc);
         }
         rs.close();
      } finally {
         if (st != null) {
            try {
               st.close();
            } catch (Exception x) {}
         }
      }
      return scoreCodes;
   }

   /**
    * Returns a list of security classification strings
    *
    * @return a list of security classification strings
    * @throws java.lang.Exception
    */
   public List<String> getSecurityClassifications() throws Exception {
      Statement st = null;
      List<String> secClasses = new ArrayList<String>();
      try {
         st = con.createStatement();
         String query = "select securityclassification from nc_securityclassification";
         ResultSet rs = st.executeQuery(query);
         while (rs.next()) {
            secClasses.add(rs.getString(1));
         }
         rs.close();
         return secClasses;

      } finally {
         if (st != null) {
            try {
               st.close();
            } catch (Exception x) {}
         }
      }

   }
}
