package caslayout.ui.db;

/**
 * @hibernate.class table="nc_assessmentinformant"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentInformant.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AssessmentInformant extends AbstractVO {
   protected Long uniqueID;
	protected String informantRelation;
	protected String ontologySource;
	protected String conceptID;

	/**
	 * @hibernate.property column="uniqueid" not-null="true"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.id column="informantrelation" generator-class="assigned" length="128"
	 * @return
	 */
	public String getInformantRelation() {
		return informantRelation;
	}

	/**
	 * @hibernate.property column="ontologysource" length="128" not-null="true"
	 * @return
	 */
	public String getOntologySource() {
		return ontologySource;
	}

	/**
	 * @hibernate.property column="conceptid" length="64" not-null="true"
	 * @return
	 */
	public String getConceptID() {
		return conceptID;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setInformantRelation(String informantRelation) {
		this.informantRelation = informantRelation;
	}

	public void setOntologySource(String ontologySource) {
		this.ontologySource = ontologySource;
	}

	public void setConceptID(String conceptID) {
		this.conceptID = conceptID;
	}
   
}
