package caslayout.ui.db;

/**
 * @hibernate.class table="nc_assessmentinteger"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentInteger.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AssessmentInteger extends BaseVO {
	protected Long assessmentDataUniqueID;
	protected Long dataValue;
	protected Long dataNormValue;
	protected Long storedAssessmentID;
	protected Long uniqueID;

	/**
	 * @hibernate.id column="nc_assessmentdata_uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getAssessmentDataUniqueID() {
		return assessmentDataUniqueID;
	}

	/**
	 * @hibernate.property column="datanormvalue" 
	 * @return
	 */
	public Long getDataNormValue() {
		return dataNormValue;
	}

	/**
	 * @hibernate.property column="datavalue"
	 * @return
	 */
	public Long getDataValue() {
		return dataValue;
	}

	/**
	 * @hibernate.property column="storedassessmentid"  not-null="true"
	 * @return
	 */
	public Long getStoredAssessmentID() {
		return storedAssessmentID;
	}

	
	/**
	 * @hibernate.property column="uniqueid"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}


	public void setAssessmentDataUniqueID(Long assessmentDataUniqueID) {
		this.assessmentDataUniqueID = assessmentDataUniqueID;
	}


	public void setDataNormValue(Long dataNormValue) {
		this.dataNormValue = dataNormValue;
	}

	public void setDataValue(Long dataValue) {
		this.dataValue = dataValue;
	}


	public void setStoredAssessmentID(Long storedAssessmentID) {
		this.storedAssessmentID = storedAssessmentID;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Assessmentinteger::[");
		buf.append("tableid=").append(tableID);
		buf.append(',');
		buf.append("assessmentDataUniqueID=")
				.append(assessmentDataUniqueID);
		buf.append(',');
		buf.append("scoreorder=").append(scoreOrder);
		buf.append(',');
		buf.append("owner=").append(owner);
		buf.append(',');
		buf.append("modtime=").append(modTime);
		buf.append(',');
		buf.append("moduser=").append(modUser);
		buf.append(',');
		buf.append("textvalue=").append(textValue);
		buf.append(',');
		buf.append("textnormvalue=").append(textNormValue);
		buf.append(',');
		buf.append("comments=").append(comments);
		buf.append(',');
		buf.append("datavalue=").append(dataValue);
		buf.append(',');
		buf.append("datanormvalue=").append(dataNormValue);
		buf.append(',');
		buf.append("storedassessmentid=").append(storedAssessmentID);
		buf.append(',');
		buf.append("assessmentid=").append(assessmentID);
		buf.append(',');
		buf.append("scorename=").append(scoreName);
		buf.append(',');
		buf.append("scoretype=").append(scoreType);
		buf.append(',');
		buf.append("isvalidated=").append(isvalidated);
		buf.append(',');
		buf.append("isranked=").append(isranked);
		buf.append(',');
		buf.append("subjectid=").append(subjectID);
		buf.append(',');
		buf.append("entryid=").append(entryID);
		buf.append(',');
		buf.append("keyerid=").append(keyerID);
		buf.append(',');
		buf.append("raterid=").append(raterID);
		buf.append(',');
		buf.append("classification=").append(classification);
		buf.append(',');
		buf.append("uniqueid=").append(uniqueID);
		buf.append(']');
		return buf.toString();
	}

}
