package caslayout.ui.db;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

/**
 * 
 * @hibernate.class table="nc_assessmentitem"
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentItem.java,v 1.3 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AssessmentItem extends AbstractVO {
	protected Long assessmentID;
	protected String scoreName;
	protected String itemLeadingText;
	protected String itemTrailingText;

	protected Long uniqueID;

	protected static PropertyDescriptor[] propDescArr;

	static {
		try {
			BeanInfo bi = Introspector.getBeanInfo(AssessmentItem.class);
			propDescArr = bi.getPropertyDescriptors();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}

	public AssessmentItem() {
	}

	public AssessmentItem(Long assessmentID, String scoreName) {
		this.assessmentID = assessmentID;
		this.scoreName = scoreName;
	}

	public AssessmentItem(AssessmentItem other) throws Exception {
		for (int i = 0; i < propDescArr.length; i++) {
			Method readMethod = propDescArr[i].getReadMethod();
			Method writeMethod = propDescArr[i].getWriteMethod();
			if (readMethod == null || writeMethod == null)
				continue;

			Object value = readMethod.invoke(other, new Object[0]);
			writeMethod.invoke(this, new Object[] { value });
		}
	}

	public boolean isSame(AssessmentItem other) throws Exception {
		for (int i = 0; i < propDescArr.length; i++) {
			Method readMethod = propDescArr[i].getReadMethod();
			if (readMethod == null)
				continue;

			Object thisValue = readMethod.invoke(this, new Object[0]);
			Object thatValue = readMethod.invoke(other, new Object[0]);
			if (thisValue == null && thatValue == null)
				continue;
			if (thisValue == null || thatValue == null)
				return false;
			if (!thisValue.equals(thatValue))
				return false;
		}
		return true;
	}

	// ---------------------- setters --------------
	public void setAssessmentID(Long newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setScoreName(String newScoreName) {
		this.scoreName = newScoreName;
	}

	public void setItemLeadingText(String newItemLeadingText) {
		this.itemLeadingText = newItemLeadingText;
	}

	public void setItemTrailingText(String newItemTrailingText) {
		this.itemTrailingText = newItemTrailingText;
	}


	public void setUniqueID(Long newUniqueID) {
		this.uniqueID = newUniqueID;
	}

	// ---------------------- getters --------------
	
	/**
	 * @hibernate.property column="assessmentid" not-null="true"
	 */
	public Long getAssessmentID() {
		return this.assessmentID;
	}

	/**
	 * @hibernate.property column="scorename" length="128" not-null="true"
	 * @return
	 */
	public String getScoreName() {
		return this.scoreName;
	}

	/**
	 * @hibernate.property column="itemleadingtext" length="2028"
	 * @return
	 */
	public String getItemLeadingText() {
		return this.itemLeadingText;
	}

	/**
	 * @hibernate.property column="itemtrailingtext" length="2028"
	 * @return
	 */
	public String getItemTrailingText() {
		return this.itemTrailingText;
	}

	
	/**
	 *
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return this.uniqueID;
	}

	
	public String toString() {
		StringBuffer buf = new StringBuffer(272);
		buf.append("AssessmentItem::[");
		buf.append("assessmentID=").append(assessmentID);
		buf.append(", scoreName=").append(scoreName);
		buf.append(", itemLeadingText=").append(itemLeadingText);
		buf.append(", itemTrailingText=").append(itemTrailingText);
		buf.append(", tableID=").append(tableID);
		buf.append(", uniqueID=").append(uniqueID);
		buf.append(", owner=").append(owner);
		buf.append(", modTime=").append(modTime);
		buf.append(", modUser=").append(modUser);
		buf.append(']');
		return buf.toString();
	}

}
