package caslayout.ui.db;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * @hibernate.class table="nc_assessmentscore"
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentScore.java,v 1.12 2008/10/13 23:58:08 bozyurt Exp $
 */

public class AssessmentScore extends AbstractVO {
	protected Long assessmentID;
	protected String scoreName;
	protected Integer scoreSequence;
	protected String scoreType;
	protected String scoreTypeFormat;
	protected Boolean nullable;
	protected Integer scoreLevel;
	protected AssessmentScore parent;

	protected Long uniqueID;
	protected String defaultValue;

	protected String assessmentOntology;
	protected String assessmentConcept;
	protected String securityClassification;
	protected Long parentAsID;
	protected String parentScore;

	// newly added to the schema Sept 20
	protected Integer minAnswers;
	protected Integer maxAnswers;
	protected Boolean isRequired;
	protected Boolean isExcluded;
	protected Boolean isNew;
	protected Boolean isModified;
	protected String description;

	protected Assessment assessment;

	protected List<AssessmentScoreCode> scoreCodes = new LinkedList<AssessmentScoreCode>();

	public AssessmentScore() {
	}

	public AssessmentScore(Long assessmentID, String scoreName) {
		this.assessmentID = assessmentID;
		this.scoreName = scoreName;
	}

	public AssessmentScore(AssessmentScore other) throws Exception {
		BeanInfo bi = Introspector.getBeanInfo(this.getClass());
		PropertyDescriptor[] propDescArr = bi.getPropertyDescriptors();
		for (int i = 0; i < propDescArr.length; i++) {
			Method readMethod = propDescArr[i].getReadMethod();
			Method writeMethod = propDescArr[i].getWriteMethod();

			Object value = readMethod.invoke(other, new Object[0]);
			writeMethod.invoke(this, new Object[] { value });
		}
	}

	public boolean isSame(AssessmentScore other) throws Exception {
		BeanInfo bi = Introspector.getBeanInfo(this.getClass());
		PropertyDescriptor[] propDescArr = bi.getPropertyDescriptors();
		for (int i = 0; i < propDescArr.length; i++) {
			Method readMethod = propDescArr[i].getReadMethod();
			if (readMethod == null)
				continue;
			Object thisValue = readMethod.invoke(this, new Object[0]);
			Object thatValue = readMethod.invoke(other, new Object[0]);
			if (thisValue == null && thatValue == null)
				continue;
			if (thisValue == null || thatValue == null)
				return false;
			if (!thisValue.equals(thatValue))
				return false;
		}
		return true;
	}

	public void addScoreCode(AssessmentScoreCode asc) {
		scoreCodes.add(asc);
	}

	public List<AssessmentScoreCode> getScoreCodes() {
		return scoreCodes;
	}

	public void setAssessmentID(Long newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setScoreName(String newScoreName) {
		this.scoreName = newScoreName;
	}

	public void setScoreSequence(Integer newScoreSequence) {
		this.scoreSequence = newScoreSequence;
	}

	public void setScoreType(String newScoreType) {
		this.scoreType = newScoreType;
	}

	public void setScoreTypeFormat(String newScoreTypeFormat) {
		this.scoreTypeFormat = newScoreTypeFormat;
	}

	public void setNullable(Boolean newNullable) {
		this.nullable = newNullable;
	}

	public void setScoreLevel(Integer newScoreLevel) {
		this.scoreLevel = newScoreLevel;
	}

	public void setParent(AssessmentScore newParent) {
		this.parent = newParent;
		setParentScore(this.parent.getScoreName());
		if (this.parent.getAssessmentID() != null)
			setParentAsID( this.parent.getAssessmentID() );
	}

	// not persisted

	public void setUniqueID(Long newUniqueID) {
		this.uniqueID = newUniqueID;
	}

	public void setDefaultValue(String newDefaultValue) {
		this.defaultValue = newDefaultValue;
	}

	public void setAssessmentOntology(String newAssessmentOntology) {
		this.assessmentOntology = newAssessmentOntology;
	}

	public void setAssessmentConcept(String newAssessmentConcept) {
		this.assessmentConcept = newAssessmentConcept;
	}

	public void setSecurityClassification(String newSecurityClassification) {
		this.securityClassification = newSecurityClassification;
	}

	public void setParentAsID(Long newParentAsID) {
		this.parentAsID = newParentAsID;
	}

	public void setParentScore(String newParentScore) {
		this.parentScore = newParentScore;
	}

	public void setMinAnswers(Integer newMinAnswers) {
		this.minAnswers = newMinAnswers;
	}

	public void setMaxAnswers(Integer newMaxAnswers) {
		this.maxAnswers = newMaxAnswers;
	}

	public void setIsRequired(Boolean newIsRequired) {
		this.isRequired = newIsRequired;
	}

	public void setIsExcluded(Boolean newIsExcluded) {
		this.isExcluded = newIsExcluded;
	}

	public void setIsNew(Boolean newIsNew) {
		this.isNew = newIsNew;
	}

	public void setIsModified(Boolean newIsModified) {
		this.isModified = newIsModified;
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
	}

	public void setAssessment(Assessment as) {
		this.assessment = as;
		setAssessmentID(as.getID());
	}

	// getters

	/**
	 * @hibernate.many-to-one column="assessmentid" cascade="none"
	 * not-null="true"
	 * foreign-key="REFNC_ASSESSMENT791";
	 */
	public Assessment getAssessment() {
		return assessment;
	}


	public Long getAssessmentID() {
		return this.assessmentID;
	}

	/**
	 * @hibernate.property column="scorename" length="128" not-null="true"
	 * @return
	 */
	public String getScoreName() {
		return this.scoreName;
	}

	/**
	 * @hibernate.property column="scoresequence"  not-null="true"
	 * @return
	 */
	public Integer getScoreSequence() {
		return this.scoreSequence;
	}

	/**
	 * @hibernate.property column="scoretype" length="64" not-null="true"
	 * @return
	 */
	public String getScoreType() {
		return this.scoreType;
	}

	public String getScoreTypeFormat() {
		return this.scoreTypeFormat;
	}

	/**
	 * @hibernate.property column="nullable"  not-null="true"
	 * @return
	 */
	public Boolean getNullable() {
		return this.nullable;
	}

	/**
	 * @hibernate.property column="scorelevel"  not-null="true"
	 * @return
	 */
	public Integer getScoreLevel() {
		return this.scoreLevel;
	}

	public AssessmentScore getParent() {
		return this.parent;
	}

	// not persisted


	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */

	public Long getUniqueID() {
		return this.uniqueID;
	}


	/**
	 * @hibernate.property column="defaultvalue" length="255"
	 * @return
	 */
	public String getDefaultValue() {
		return this.defaultValue;
	}

	/**
	 * @hibernate.property column="assessmentontology" length="128" not-null="true"
	 * @return
	 */
	public String getAssessmentOntology() {
		return this.assessmentOntology;
	}

	/**
	 * @hibernate.property column="assessmentconcept" length="64" not-null="true"
	 * @return
	 */
	public String getAssessmentConcept() {
		return this.assessmentConcept;
	}

	/**
	 * @hibernate.property column="securityclassification" length="128" not-null="true"
	 * @return
	 */
	public String getSecurityClassification() {
		return this.securityClassification;
	}

	/**
	 * @hibernate.property column="parentasid"
	 * @return
	 */
	public Long getParentAsID() {
		return this.parentAsID;
	}

	/**
	 * @hibernate.property column="parentscore"
	 * @return
	 */
	public String getParentScore() {
		return this.parentScore;
	}

	/**
	 * @hibernate.property column="minanswers"
	 * @return
	 */
	public Integer getMinAnswers() {
		return this.minAnswers;
	}

	/**
	 * @hibernate.property column="maxanswers"
	 * @return
	 */
	public Integer getMaxAnswers() {
		return this.maxAnswers;
	}

	/**
	 * @hibernate.property column="isrequired"
	 * @return
	 */
	public Boolean getIsRequired() {
		return this.isRequired;
	}

	/**
	 * @hibernate.property column="isexcluded"
	 * @return
	 */
	public Boolean getIsExcluded() {
		return this.isExcluded;
	}

	/**
	 * @hibernate.property column="isnew"
	 * @return
	 */
	public Boolean getIsNew() {
		return this.isNew;
	}

	/**
	 * @hibernate.property column="ismodified"
	 * @return
	 */
	public Boolean getIsModified() {
		return this.isModified;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return this.description;
	}

	public int hashCode() {
		StringBuffer buf = new StringBuffer();
		buf.append(assessmentID).append('_').append(scoreName);
		return buf.toString().hashCode();
	}

	public boolean equals(Object other) {
		if (other == this) {
			return true;
		}
		if (other == null || !(other instanceof AssessmentScore)) {
			return false;
		}
		AssessmentScore that = (AssessmentScore) other;
		return assessmentID == that.assessmentID
				&& scoreName.equals(that.scoreName);
	}


	public String toString() {
		StringBuffer buf = new StringBuffer(776);
		buf.append("AssessmentScore::[");
		buf.append("assessmentID=").append(assessmentID);
		buf.append(", scoreName=").append(scoreName);
		buf.append(", scoreSequence=").append(scoreSequence);
		buf.append(", scoreType=").append(scoreType);
		buf.append(", scoreTypeFormat=").append(scoreTypeFormat);
		buf.append(", nullable=").append(nullable);
		buf.append(", scoreLevel=").append(scoreLevel);
		buf.append(", parent=").append(parent);
		buf.append(", tableID=").append(tableID);
		buf.append(", uniqueID=").append(uniqueID);
		buf.append(", owner=").append(owner);
		buf.append(", modTime=").append(modTime);
		buf.append(", modUser=").append(modUser);
		buf.append(", defaultValue=").append(defaultValue);
		buf.append(", assessmentOntology=").append(assessmentOntology);
		buf.append(", assessmentConcept=").append(assessmentConcept);
		buf.append(", securityClassification=").append(securityClassification);
		buf.append(", parentAsID=").append(parentAsID);
		buf.append(", parentScore=").append(parentScore);
		buf.append(", minAnswers=").append(minAnswers);
		buf.append(", maxAnswers=").append(maxAnswers);
		buf.append(", isRequired=").append(isRequired);
		buf.append(", isExcluded=").append(isExcluded);
		buf.append(", isNew=").append(isNew);
		buf.append(", isModified=").append(isModified);
		buf.append(", description=").append(description);
		if ( scoreCodes != null && ! scoreCodes.isEmpty()) {
			for (Iterator<AssessmentScoreCode> iter = scoreCodes.iterator(); iter.hasNext();) {
				AssessmentScoreCode sc = iter.next();
				buf.append("\n\t").append( sc.toString());
			}
		}
		buf.append(']');
		return buf.toString();
	}

}