package caslayout.ui.db;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

/**
 * 
 * @hibernate.class table="nc_assessmentscorecode"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentScoreCode.java,v 1.13 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AssessmentScoreCode extends AbstractVO {
	protected Long assessmentID;
	protected String scoreName;
	protected String scoreCode;
	protected String scoreCodeValue;
	protected String scoreCodeType;
	protected String scoreCodeTypeFormat;

	protected Long uniqueID;

	// added to the schema Sept 20
	protected String description;
	protected String ontologySource;
	protected String conceptID;
	protected String scoreCodeLabel;

	protected static PropertyDescriptor[] propDescArr;

	static {
		try {
			BeanInfo bi = Introspector.getBeanInfo(AssessmentScoreCode.class);
			propDescArr = bi.getPropertyDescriptors();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}

	public AssessmentScoreCode(Long assessmentID, String scoreName,
			String scoreCode, String scoreCodeValue, String scoreCodeType,
			String scoreCodeTypeFormat) {
		this.assessmentID = assessmentID;
		this.scoreName = scoreName;
		this.scoreCode = scoreCode;
		this.scoreCodeValue = scoreCodeValue;
		this.scoreCodeType = scoreCodeType;
		if (scoreCodeTypeFormat == null)
			this.scoreCodeTypeFormat = "";
		else
			this.scoreCodeTypeFormat = scoreCodeTypeFormat;
	}

	public AssessmentScoreCode() {
	}

	public AssessmentScoreCode(AssessmentScoreCode other) throws Exception {
		for (int i = 0; i < propDescArr.length; i++) {
			Method readMethod = propDescArr[i].getReadMethod();
			Method writeMethod = propDescArr[i].getWriteMethod();
			if (readMethod == null || writeMethod == null)
				continue;
			Object value = readMethod.invoke(other, new Object[0]);
			writeMethod.invoke(this, new Object[] { value });
		}
	}

	public boolean isSame(AssessmentScoreCode other) throws Exception {
		for (int i = 0; i < propDescArr.length; i++) {
			Method readMethod = propDescArr[i].getReadMethod();
			if (readMethod == null)
				continue;
			Object thisValue = readMethod.invoke(this, new Object[0]);
			Object thatValue = readMethod.invoke(other, new Object[0]);
			if (thisValue == null && thatValue == null)
				continue;
			if (thisValue == null || thatValue == null)
				return false;
			if (!thisValue.equals(thatValue))
				return false;
		}
		return true;
	}

	// ---------------------- setters --------------
	public void setAssessmentID(Long newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setScoreName(String newScoreName) {
		this.scoreName = newScoreName;
	}

	public void setScoreCode(String newScoreCode) {
		this.scoreCode = newScoreCode;
	}

	public void setScoreCodeValue(String newScoreCodeValue) {
		this.scoreCodeValue = newScoreCodeValue;
	}

	public void setScoreCodeType(String newScoreCodeType) {
		this.scoreCodeType = newScoreCodeType;
	}

	public void setScoreCodeTypeFormat(String newScoreCodeTypeFormat) {
		if (newScoreCodeTypeFormat == null)
			this.scoreCodeTypeFormat = "";
		else
			this.scoreCodeTypeFormat = newScoreCodeTypeFormat;
	}

	// transient
	
	public void setUniqueID(Long newUniqueID) {
		this.uniqueID = newUniqueID;
	}

	
	public void setDescription(String newDescription) {
		this.description = newDescription;
	}

	public void setOntologySource(String newOntologySource) {
		this.ontologySource = newOntologySource;
	}

	public void setConceptID(String newConceptID) {
		this.conceptID = newConceptID;
	}

	public void setScoreCodeLabel(String newScoreCodeLabel) {
		this.scoreCodeLabel = newScoreCodeLabel;
	}

	// ---------------------- getters --------------
	/**
	 * @hibernate.property column="assessmentid" not-null="true"
	 */
	public Long getAssessmentID() {
		return this.assessmentID;
	}

	/**
	 * @hibernate.property column="scorename" length="128" not-null="true" 
	 * @return
	 */
	public String getScoreName() {
		return this.scoreName;
	}

	/**
	 * @hibernate.property column="scorecode" length="128" not-null="true"
	 * @return
	 */
	public String getScoreCode() {
		return this.scoreCode;
	}

	/**
	 * @hibernate.property column="scorecodevalue" length="255" not-null="true"
	 * @return
	 */
	public String getScoreCodeValue() {
		return this.scoreCodeValue;
	}

	/**
	 * @hibernate.property column="scorecodetype" length="64" not-null="true"
	 * @return
	 */
	public String getScoreCodeType() {
		return this.scoreCodeType;
	}

    public String getScoreCodeTypeFormat() {
		return this.scoreCodeTypeFormat;
	}

	
	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return this.uniqueID;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * @hibernate.property column="ontologysource" length="128"
	 * @return
	 */
	public String getOntologySource() {
		return this.ontologySource;
	}

	/**
	 * @hibernate.property column="conceptid" length="64"
	 * @return
	 */
	public String getConceptID() {
		return this.conceptID;
	}

	/**
	 * @hibernate.property column="scorecodelabel" length="255" not-null="true"
	 * @return
	 */
	public String getScoreCodeLabel() {
		return this.scoreCodeLabel;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(488);
		buf.append("AssessmentScoreCode::[");
		buf.append("assessmentID=").append(assessmentID);
		buf.append(", scoreName=").append(scoreName);
		buf.append(", scoreCode=").append(scoreCode);
		buf.append(", scoreCodeValue=").append(scoreCodeValue);
		buf.append(", scoreCodeType=").append(scoreCodeType);
		buf.append(", scoreCodeTypeFormat=").append(scoreCodeTypeFormat);
		buf.append(", tableID=").append(tableID);
		buf.append(", uniqueID=").append(uniqueID);
		buf.append(", owner=").append(owner);
		buf.append(", modTime=").append(modTime);
		buf.append(", modUser=").append(modUser);
		buf.append(", description=").append(description);
		buf.append(", ontologySource=").append(ontologySource);
		buf.append(", conceptID=").append(conceptID);
		buf.append(']');
		return buf.toString();
	}

}
