package caslayout.ui.db;

/**
 * @hibernate.class table="nc_assessmentstatus"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentStatus.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AssessmentStatus extends AbstractVO {
	protected String status;
	protected Long uniqueID;
	protected String name;
	protected String description;

	/**
	 * @hibernate.id column="status" generator-class="assigned" length="64" 
	 * @return
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @hibernate.property column="uniqueid" not-null="true"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="name" not-null="true" length="128"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
}
