package caslayout.ui.db;

/**
 * @hibernate.class table="nc_assessmentvarchar"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentVarchar.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AssessmentVarchar extends BaseVO {
	protected Long assessmentDataUniqueID;
	protected String dataValue;
	protected String dataNormValue;
	protected Long storedAssessmentID;
	protected Long uniqueID;
	
	/**
	 * @hibernate.id column="nc_assessmentdata_uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getAssessmentDataUniqueID() {
		return assessmentDataUniqueID;
	}
	
	/**
	 * @hibernate.property column="datanormvalue" length="255" 
	 * @return
	 */
	public String getDataNormValue() {
		return dataNormValue;
	}
	
	/**
	 * @hibernate.property column="datavalue" length="255"
	 * @return
	 */
	public String getDataValue() {
		return dataValue;
	}
	
	/**
	 *  @hibernate.property column="storedassessmentid"  not-null="true"
	 * @return
	 */
	public Long getStoredAssessmentID() {
		return storedAssessmentID;
	}
	
	/**
	 * @hibernate.property column="uniqueid"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}
	

	
	public void setAssessmentDataUniqueID(Long assessmentDataUniqueID) {
		this.assessmentDataUniqueID = assessmentDataUniqueID;
	}
	public void setDataNormValue(String dataNormValue) {
		this.dataNormValue = dataNormValue;
	}
	public void setDataValue(String dataValue) {
		this.dataValue = dataValue;
	}
	public void setStoredAssessmentID(Long storedAssessmentID) {
		this.storedAssessmentID = storedAssessmentID;
	}
	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}
}
