package caslayout.ui.db;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BaseVO.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class BaseVO {
	protected Long tableID;
	protected Long owner;
	protected java.util.Date modTime;
	protected Long modUser;
	protected Long assessmentID;
	protected String scoreName;
	protected String scoreType;
	protected Long scoreOrder;
	protected Boolean isvalidated;
	protected Boolean isranked;
	protected String subjectID;
	protected Long entryID;
	protected Long keyerID;
	protected Long raterID;
	protected Long classification;
	protected String textValue;
	protected String textNormValue;
	protected String comments;
	
		

	/**
	 * @hibernate.property column="assessmentid" not-null="true"
	 * @return
	 */
	public Long getAssessmentID() {
		return assessmentID;
	}
	
	/**
	 * @hibernate.property column="classification" 
	 * @return
	 */
	public Long getClassification() {
		return classification;
	}
	

	/**
	 * @hibernate.property column="comments" type="text" 
	 * @return
	 */
	public String getComments() {
		return comments;
	}


	/**
	 * @hibernate.property column="textnormvalue" length="255"
	 * @return
	 */
	public String getTextNormValue() {
		return textNormValue;
	}

	/**
	 * @hibernate.property column="textvalue" length="255"
	 * @return
	 */
	public String getTextValue() {
		return textValue;
	}

	
	public void setComments(String comments) {
		this.comments = comments;
	}

	public void setTextNormValue(String textNormValue) {
		this.textNormValue = textNormValue;
	}

	public void setTextValue(String textValue) {
		this.textValue = textValue;
	}

	/**
	 * @hibernate.property column="entryid"
	 * @return
	 */
	public Long getEntryID() {
		return entryID;
	}

	/**
	 * @hibernate.property column="isranked"
	 * @return
	 */
	public Boolean getIsranked() {
		return isranked;
	}

	/**
	 * @hibernate.property column="isvalidated" not-null="true"
	 * @return
	 */
	public Boolean getIsvalidated() {
		return isvalidated;
	}

	/**
	 * @hibernate.property column="keyerid"
	 * @return
	 */
	public Long getKeyerID() {
		return keyerID;
	}

	
	/**
	 * @hibernate.property column="raterid"
	 * @return
	 */
	public Long getRaterID() {
		return raterID;
	}

	/**
	 * @hibernate.property column="scorename" length="128" not-null="true"
	 * @return
	 */
	public String getScorename() {
		return scoreName;
	}

	
	
	/**
	 * @hibernate.property column="tableid" not-null="true"
	 * @return
	 */
	public Long getTableID() {
		return tableID;
	}
	
	/**
	 * @hibernate.property column="modtime" type="timestamp" not-null="true"
	 * @return
	 */
	public java.util.Date getModTime() {
		return modTime;
	}

	/**
	 * @hibernate.property column="moduser" not-null="true"
	 * @return
	 */
	public Long getModUser() {
		return modUser;
	}

	/**
	 * @hibernate.property column="owner" not-null="true"
	 * @return
	 */
	public Long getOwner() {
		return owner;
	}
	
	
	
	/**
	 * @hibernate.property column="scoretype" length="64" not-null="true"
	 * @return
	 */
	public String getScoretype() {
		return scoreType;
	}
	
	/**
	 * @hibernate.property column="scoreorder"  not-null="true"
	 * @return
	 */
	public Long getScoreOrder() {
		return scoreOrder;
	}

	public void setScoreOrder(Long scoreOrder) {
		this.scoreOrder = scoreOrder;
	}

	/**
	 * @hibernate.property column="subjectid" length="64" not-null="true"
	 * @return
	 */
	public String getSubjectID() {
		return subjectID;
	}

	

	public void setTableID(Long tableID) {
		this.tableID = tableID;
	}
	
	public void setModTime(java.util.Date modTime) {
		this.modTime = modTime;
	}

	public void setModUser(Long modUser) {
		this.modUser = modUser;
	}

	public void setOwner(Long owner) {
		this.owner = owner;
	}

	public void setAssessmentID(Long assessmentID) {
		this.assessmentID = assessmentID;
	}

	public void setClassification(Long classification) {
		this.classification = classification;
	}

	public void setEntryID(Long entryID) {
		this.entryID = entryID;
	}

	public void setIsranked(Boolean isranked) {
		this.isranked = isranked;
	}

	public void setIsvalidated(Boolean isvalidated) {
		this.isvalidated = isvalidated;
	}

	public void setKeyerID(Long keyerID) {
		this.keyerID = keyerID;
	}

	public void setRaterID(Long raterID) {
		this.raterID = raterID;
	}

	public void setScorename(String scorename) {
		this.scoreName = scorename;
	}

	public void setScoretype(String scoretype) {
		this.scoreType = scoretype;
	}

	public void setSubjectID(String subjectID) {
		this.subjectID = subjectID;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("BaseVO::[");
		buf.append("assessmentID=").append(assessmentID);
		buf.append(",scoreName=").append(scoreName);		
		
		buf.append(']');
		return buf.toString();
	}

}
