package caslayout.ui.db;

import caslayout.Constants;

public class DAOFactory {
  protected DAOFactory() {}


  public static IAssessmentDAO createAsssessmentDAO(String dbType) {
    if (dbType.equals(Constants.ORACLE) ) {
       return new caslayout.ui.db.oracle.AssessmentDAO();
    } else if ( dbType.equals(Constants.POSTGRES) ) {
      return new caslayout.ui.db.postgres.AssessmentDAO();
    }
    return null;
  }

  public static IAssessmentScoreDAO createAsssessmentScoreDAO(String dbType) {
    if (dbType.equals(Constants.ORACLE) ) {
       return new caslayout.ui.db.oracle.AssessmentScoreDAO();
    } else if ( dbType.equals(Constants.POSTGRES) ) {
      return new caslayout.ui.db.postgres.AssessmentScoreDAO();
    }
    return null;
  }

  public static IAssessmentScoreCodeDAO createAsssessmentScoreCodeDAO(String dbType) {
    if (dbType.equals(Constants.ORACLE) ) {
       return new caslayout.ui.db.oracle.AssessmentScoreCodeDAO();
    } else if ( dbType.equals(Constants.POSTGRES) ) {
      return new caslayout.ui.db.postgres.AssessmentScoreCodeDAO();
    }
    return null;
  }

  public static IAssessmentItemDAO createAsssessmentItemDAO(String dbType) {
    if (dbType.equals(Constants.ORACLE) ) {
       return new caslayout.ui.db.oracle.AssessmentItemDAO();
    } else if ( dbType.equals(Constants.POSTGRES) ) {
      return new caslayout.ui.db.postgres.AssessmentItemDAO();
    }
    return null;
  }

  public static IOntologyConceptDAO createOntologyConceptDAO(String dbType) {
    if (dbType.equals(Constants.ORACLE) ) {
       return new caslayout.ui.db.oracle.OntologyConceptDAO();
    } else if ( dbType.equals(Constants.POSTGRES) ) {
      return new caslayout.ui.db.postgres.OntologyConceptDAO();
    }
    return null;
  }

}