package caslayout.ui.db;

import guilib.common.BaseDialog;
import guilib.common.NameComboField;
import guilib.common.NameValueField;
import guilib.common.PasswordField;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import caslayout.Constants;
import caslayout.ui.CALMConfig;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DBParamsDialog.java,v 1.7 2008/10/13 23:58:08 bozyurt Exp $
 */
public class DBParamsDialog extends BaseDialog {
	private static final long serialVersionUID = -2224283638398249675L;
	protected NameValueField dbHostField, dbPortField, dbSchemaField,
			dbNameField;
	protected NameComboField dbTypeCombo;
	protected PasswordField pwdField;
	protected CALMConfig config;

	public DBParamsDialog(Frame owner, String title, CALMConfig config) {
		super(owner, title, new String[] { "Cancel", "OK"});
		this.config = config;
		init();
		pack();
	}

	protected DBURLInfo extractDBHost(String dbURL)
	{
		if (dbURL == null || dbURL.trim().length() == 0)
			return null;
		boolean postgresDB = dbURL.indexOf("postgresql") != -1;
		DBURLInfo dbURLInfo = null;
		if (postgresDB) {
			int idx = dbURL.indexOf("://");
			int endIdx = dbURL.indexOf('/', idx + 3);
			String host = dbURL.substring(idx + 3, endIdx);
			String dbName = dbURL.substring(endIdx + 1);
			/** @todo extract port also from postgres db url */
			dbURLInfo = new DBURLInfo(host, 5432, dbName);
		} else {
			int idx = dbURL.indexOf('@');
			int endIdx = dbURL.indexOf(':', idx);
			String host = dbURL.substring(idx + 1, endIdx);
			idx = endIdx + 1;
			endIdx = dbURL.indexOf(':', idx);
			int port = Integer.parseInt(dbURL.substring(idx, endIdx));
			String dbName = dbURL.substring(endIdx + 1);
			dbURLInfo = new DBURLInfo(host, port, dbName);
		}
		return dbURLInfo;
	}

	class DBURLInfo {
		String host;
		int port;
		String dbName;

		public DBURLInfo(String host, int port, String dbName) {
			this.host = host;
			this.port = port;
			this.dbName = dbName;
		}

		public String toJDBCURL(String dbType)
		{
			StringBuffer buf = new StringBuffer();
			if (dbType.equals(Constants.ORACLE)) {
				buf.append("jdbc:oracle:thin:@").append(host);
				buf.append(':').append(port).append(':').append(dbName);
			} else {
				buf.append("jdbc:postgresql://").append(host);
				buf.append('/').append(dbName);
			}
			return buf.toString();
		}
	}

	protected void init()
	{
		// JPanel labelPanel = new JPanel(new GridLayout(6, 1, 3, 3));
		JPanel labelPanel = new JPanel(new GridLayout(2, 1, 3, 3));
		labelPanel.add(new JLabel("Database Type:", JLabel.RIGHT));
		
		//labelPanel.add(new JLabel("Database Host:", JLabel.RIGHT));
		//labelPanel.add(new JLabel("Database Port:", JLabel.RIGHT));
		//labelPanel.add(new JLabel("Database Name:", JLabel.RIGHT));
		//labelPanel.add(new JLabel("Database User/Schema:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database User Password:", JLabel.RIGHT));

		//JPanel panel = new JPanel(new GridLayout(6, 1, 3, 3));
		JPanel panel = new JPanel(new GridLayout(2, 1, 3, 3));

		// DBURLInfo dui = extractDBHost(config.getDbURL());

		List<String> dbTypes = new ArrayList<String>(2);
		if (DBParamsDialog.class.getResource("/calm-oracle.cfg.xml") != null) {
			dbTypes.add(Constants.ORACLE);
		}
		if (DBParamsDialog.class.getResource("/calm-postgres.cfg.xml") != null) {
			dbTypes.add(Constants.POSTGRES);
		}
		String[] dbTypesArr = new String[ dbTypes.size()];
		dbTypesArr = dbTypes.toArray(dbTypesArr);
		panel.add(dbTypeCombo = new NameComboField(null, dbTypesArr) );
		if (config.getDbType() != null) {
			if ( dbTypes.contains(config.getDbType())) {
				dbTypeCombo.getComboBox().setSelectedItem(config.getDbType());
			}
		}
        /*
		panel.add(dbHostField = new NameValueField(null, 10));
		if (dui != null)
			dbHostField.setValue(dui.host);
		panel.add(dbPortField = new NameValueField(null, 10));
		if (dui != null)
			dbPortField.setValue("" + dui.port);
		panel.add(dbNameField = new NameValueField(null, 10));
		if (dui != null)
			dbNameField.setValue(dui.dbName);

		panel.add(dbSchemaField = new NameValueField(null, 10));
		dbSchemaField.setValue(config.getDbSchema());
        */
		
		panel.add(pwdField = new PasswordField(null, 10));

		JPanel paramPanel = new JPanel(new GridLayout(1, 2));
		paramPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		paramPanel.add(labelPanel);
		paramPanel.add(panel);
		this.setDefaultButton("OK");

		getContentPane().add(paramPanel);
	}

	private boolean hasUserData(String value)
	{
		return (value != null && value.trim().length() > 0);
	}

	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				config.setDbType((String) dbTypeCombo.getComboBox()
						.getSelectedItem());
				if (pwdField.getValue() != null
						&& pwdField.getValue().length() > 0) {
					String pwd = pwdField.getValue();
					if (pwdField.getValue().equals("<no-pwd>")) {
						pwd = "";
					}
					config.setPwd(pwd);
					this.returnCode = OK_PRESSED;
				}
			}
		}
		setVisible(false);
	}
	
	
	public void actionPerformedOld(ActionEvent e)
	{
		this.returnCode = NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {

				config.setDbType((String) dbTypeCombo.getComboBox()
						.getSelectedItem());

				if (hasUserData(dbHostField.getValue())
						&& hasUserData(dbPortField.getValue())
						&& hasUserData(dbNameField.getValue())) {
					DBURLInfo dui = new DBURLInfo(dbHostField.getValue(),
							Integer.parseInt(dbPortField.getValue()),
							dbNameField.getValue());

					config.setDbURL(dui.toJDBCURL(config.getDbType()));
				}

				if (hasUserData(dbSchemaField.getValue())) {
					config.setDbSchema(dbSchemaField.getValue().toUpperCase());
					config.setUser(dbSchemaField.getValue().toLowerCase());
				}

				if (pwdField.getValue() != null
						&& pwdField.getValue().length() > 0) {
					String pwd = pwdField.getValue();
					if (pwdField.getValue().equals("<no-pwd>")) {
						pwd = "";
						config.setNoPassword(true);
					}
					config.setPwd(pwd);
					this.returnCode = OK_PRESSED;
					// System.out.println("setting returnCode to " +
					// returnCode);
				}
			}
		}
		setVisible(false);
	}

}
