package caslayout.ui.db;

/**
 * @hibernate.class table="nc_databaseuser"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DatabaseUser.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class DatabaseUser extends AbstractVO {
   protected Long uniqueID;
	protected String name;
	protected Boolean isGroup;
	protected Person person;
	protected UserClass userClass;
	protected UserStatus userStatus;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="name" length="128" not-null="true"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="isgroup"
	 * @return
	 */
	public Boolean getIsGroup() {
		return isGroup;
	}

	/**
	 * @hibernate.many-to-one column="personid"
	 * class="caslayout.ui.db.Person" not-null="true"
	 * @return
	 */
	public Person getPerson() {
		return person;
	}

	/**
	 * @hibernate.many-to-one column="userclass"
	 * class="caslayout.ui.db.UserClass" not-null="true"
	 * @return
	 */
	public UserClass getUserClass() {
		return userClass;
	}

	/**
	 * @hibernate.many-to-one column="userstatus"
	 * class="caslayout.ui.db.UserStatus" not-null="true"
	 * @return
	 */
	public UserStatus getUserStatus() {
		return userStatus;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setIsGroup(Boolean isGroup) {
		this.isGroup = isGroup;
	}

	public void setPerson(Person person) {
		this.person = person;
	}

	public void setUserClass(UserClass userClass) {
		this.userClass = userClass;
	}

	public void setUserStatus(UserStatus userStatus) {
		this.userStatus = userStatus;
	}
   
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("DatabaseUser::[");
		buf.append("uniqueID=").append(uniqueID);
		buf.append(",name=").append(name);
		buf.append("\n").append(person.toString());
		buf.append("\n").append(userClass.toString());
		buf.append("\n").append(userStatus.toString());
		
		buf.append(']');
		return buf.toString();
	}
}
