package caslayout.ui.db;

/**
 * @hibernate.class table="nc_experiment"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Experiment.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class Experiment extends AbstractVO {
	protected Long uniqueID;
	protected String name;
	protected String description;
	protected Person contactPerson;
	protected String baseURI;
	protected Boolean regressionData;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="name" length="128" not-null="true"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @hibernate.many-to-one column="contactperson" 
	 * class="caslayout.ui.db.Person" not-null="true" outer-join="true"
	 * @return
	 */
	public Person getContactPerson() {
		return contactPerson;
	}

	/**
	 * @hibernate.property column="baseuri" length="2048"
	 * @return
	 */
	public String getBaseURI() {
		return baseURI;
	}

	/**
	 * @hibernate.property column="isregressiondata"
	 * @return
	 */
	public Boolean getRegressionData() {
		return regressionData;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setContactPerson(Person contactPerson) {
		this.contactPerson = contactPerson;
	}

	public void setBaseURI(String baseURI) {
		this.baseURI = baseURI;
	}

	public void setRegressionData(Boolean regressionData) {
		this.regressionData = regressionData;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Experiment::[");
		buf.append("uniqueID=").append(uniqueID);
		buf.append(",name=").append(name);
		buf.append(",baseURI=").append(baseURI);
		buf.append(",regressionData=").append(regressionData);
		buf.append("\n").append(contactPerson.toString());
		buf.append( super.toString());
		buf.append(']');
		return buf.toString();
	}

}
