package caslayout.ui.db;


/**
 * @hibernate.class table="nc_ontologyconcept"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: OntologyConcept.java,v 1.3 2007/10/08 18:00:41 bozyurt Exp $
 */
public class OntologyConcept extends AbstractVO {
	protected String ontologySource;
	protected String conceptID;
	protected String concept;
	protected Long uniqueID;
	protected String ontologyPath;

	public OntologyConcept() {
	}

	public OntologyConcept(String ontologySource, String conceptID,
			String concept) {
		this.ontologySource = ontologySource;
		this.conceptID = conceptID;
		this.concept = concept;
	}

	// ---------------------- setters --------------
	public void setOntologySource(String newOntologySource) {
		this.ontologySource = newOntologySource;
	}

	public void setConceptID(String newConceptID) {
		this.conceptID = newConceptID;
	}

	public void setConcept(String newConcept) {
		this.concept = newConcept;
	}

	public void setUniqueID(Long newUniqueID) {
		this.uniqueID = newUniqueID;
	}

	public void setOntologyPath(String newOntologyPath) {
		this.ontologyPath = newOntologyPath;
	}

	
	/**
	 * @hibernate.property column="ontologysource" length="128" not-null="true"
	 * @return
	 */
	public String getOntologySource() {
		return this.ontologySource;
	}

	/**
	 * @hibernate.property column="conceptid" length="64" not-null="true"
	 * @return
	 */
	public String getConceptID() {
		return this.conceptID;
	}

	/**
	 * @hibernate.property column="concept" length="128" not-null="true"
	 * @return
	 */
	public String getConcept() {
		return this.concept;
	}

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return this.uniqueID;
	}

	
	/**
	 * @hibernate.property column="ontologypath" length="2048"
	 * @return
	 */
	public String getOntologyPath() {
		return this.ontologyPath;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(248);
		buf.append("OntologyConcept::[");
		buf.append("ontologySource=").append(ontologySource);
		buf.append(", conceptID=").append(conceptID);
		buf.append(", concept=").append(concept);
		buf.append(", uniqueID=").append(uniqueID);
		buf.append(", tableID=").append(tableID);
		buf.append(", owner=").append(owner);
		buf.append(", modUser=").append(modUser);
		buf.append(", modTime=").append(modTime);
		buf.append(", ontologyPath=").append(ontologyPath);
		buf.append(']');
		return buf.toString();
	}

}