package caslayout.ui.db;

/**
 * @hibernate.class table="nc_person"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Person.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class Person extends AbstractVO {
    protected Long uniqueID;
    protected String firstName;
    protected String lastName;
    protected String email;
    
    public Person() {
	}
	
    /**
     * @hibernate.id column="uniqueid" generator-class="sequence"
     * @return
     */
    public Long getUniqueID() {
		return uniqueID;
	}

    /**
     * @hibernate.property column="first_name" length="128" not-null="true"
     * @return
     */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * @hibernate.property column="last_name" length="128" not-null="true"
	 * @return
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * @hibernate.property column="email" length="256" not-null="true"
	 * @return
	 */
	public String getEmail() {
		return email;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Person::[");
		buf.append("uniqueID=").append(uniqueID);
		buf.append(",firstName=").append(firstName);
		buf.append(",lastName=").append(lastName);
		buf.append(",email=").append(email);
		buf.append(']');
		return buf.toString();
	}

}
