package caslayout.ui.db;

/**
 * @hibernate.class table="nc_protocol" lazy="false"
 * @author I. Burak Ozyurt
 * @version $Id: Protocol.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class Protocol extends AbstractVO {
	protected ProtocolKey protocolKey;
	protected Long uniqueID;
	protected String name;
	protected String description;

	/**
	 * @hibernate.id generator-type="assigned"
	 * @return
	 */
	public ProtocolKey getProtocolKey() {
		return protocolKey;
	}
	
	/**
	 * @hibernate.property column="uniqueid" not-null="true"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="name" length="128"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Protocol::[");
		buf.append(protocolKey.toString());
		buf.append(",name=").append(name);
		buf.append( super.toString());
		buf.append(']');
		return buf.toString();
	}

	

	public void setProtocolKey(ProtocolKey protocolKey) {
		this.protocolKey = protocolKey;
	}
}
