package caslayout.ui.db;

import java.io.Serializable;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ProtocolKey.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class ProtocolKey implements Serializable {
	private String protocolId;
	private Long protocolVersion;
	
	private static final long serialVersionUID = 1L;

	public ProtocolKey() {}
	
	public ProtocolKey(String protocolId, Long protocolVersion) {
		super();
		this.protocolId = protocolId;
		this.protocolVersion = protocolVersion;
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((protocolId == null) ? 0 : protocolId.hashCode());
		result = prime * result
				+ ((protocolVersion == null) ? 0 : protocolVersion.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ProtocolKey other = (ProtocolKey) obj;
		if (protocolId == null) {
			if (other.protocolId != null)
				return false;
		} else if (!protocolId.equals(other.protocolId))
			return false;
		if (protocolVersion == null) {
			if (other.protocolVersion != null)
				return false;
		} else if (!protocolVersion.equals(other.protocolVersion))
			return false;
		return true;
	}

	/**
	 * @hibernate.property column="protocolid" length="64"
	 * @return
	 */
	public String getProtocolId() {
		return protocolId;
	}

	/**
	 * @hibernate.property column="protocolversion" 
	 * @return
	 */
	public Long getProtocolVersion() {
		return protocolVersion;
	}
	
	public void setProtocolId(String protocolId) {
		this.protocolId = protocolId;
	}

	public void setProtocolVersion(Long protocolVersion) {
		this.protocolVersion = protocolVersion;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("ProtocolKey::[");
		buf.append("protocolId=").append(protocolId);
		buf.append(",protocolVersion=").append(protocolVersion);
		buf.append(']');
		return buf.toString();
	}

	

}
