package caslayout.ui.db;

/**
 * @hibernate.class table="nc_researchgroup"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ResearchGroup.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class ResearchGroup extends AbstractVO {
	protected Long uniqueID;
	protected String name;
	protected String description;
	protected ResearchGroupType researchGroupType;
	protected Experiment experiment;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="name" length="128" not-null="true"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @hibernate.many-to-one column="nc_researchgrouptype_uniqueid"
	 *                        class="caslayout.ui.db.ResearchGroupType"
	 *                        not-null="true" outer-join="true"
	 * @return
	 */
	public ResearchGroupType getResearchGroupType() {
		return researchGroupType;
	}

	/**
	 * @hibernate.many-to-one column="nc_experiment_uniqueid"
	 *                        class="caslayout.ui.db.Experiment" not-null="true"
	 *                        outer-join="true"
	 * @return
	 */
	public Experiment getExperiment() {
		return experiment;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setResearchGroupType(ResearchGroupType researchGroupType) {
		this.researchGroupType = researchGroupType;
	}

	public void setExperiment(Experiment experiment) {
		this.experiment = experiment;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("ResearchGroup::[");
		buf.append("uniqueID=").append(uniqueID);
		buf.append(",name=").append(name);
		buf.append("\nresearchGroupType=").append(researchGroupType.toString());
		buf.append("\nexperiment=").append(researchGroupType.toString());
		buf.append(super.toString());
		buf.append(']');
		return buf.toString();
	}
	
}
