package caslayout.ui.db;

import java.sql.Timestamp;

/**
 * @hibernate.class table="nc_expsegment"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Segment.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class Segment extends AbstractVO {
	protected SegmentKey segmentKey;
	protected Long uniqueID;
	protected Timestamp timeStamp;
	protected String description;
	protected Long studyID;
	protected String name;
	protected Float timeInterval;
	protected Boolean isTimeInterval;
	protected Boolean isBad;
	protected Protocol protocol;


	
	/**
	 * @hibernate.property column="uniqueid" not-null="true"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.id generator-type="assigned"
	 * @return
	 */
	public SegmentKey getSegmentKey() {
		return segmentKey;
	}

	public void setSegmentKey(SegmentKey segmentKey) {
		this.segmentKey = segmentKey;
	}

	/**
	 * @hibernate.property column="time_stamp" not-null="true"
	 * @return
	 */
	public Timestamp getTimeStamp() {
		return timeStamp;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @hibernate.property column="studyid" 
	 * @return
	 */
	public Long getStudyID() {
		return studyID;
	}

	/**
	 * @hibernate.property column="name" length="128"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="timeinterval"
	 * @return
	 */
	public Float getTimeInterval() {
		return timeInterval;
	}

	/**
	 * @hibernate.property column="istimeinterval" not-null="true"
	 * @return
	 */
	public Boolean getIsTimeInterval() {
		return isTimeInterval;
	}

	/**
	 * @hibernate.property column="isbad" not-null="true"
	 * @return
	 */
	public Boolean getIsBad() {
		return isBad;
	}

	/**
	 *  
	 * @return
	 */
	public Protocol getProtocol() {
		return protocol;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setTimeStamp(Timestamp timeStamp) {
		this.timeStamp = timeStamp;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setStudyID(Long studyID) {
		this.studyID = studyID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setTimeInterval(Float timeInterval) {
		this.timeInterval = timeInterval;
	}

	public void setIsTimeInterval(Boolean isTimeInterval) {
		this.isTimeInterval = isTimeInterval;
	}

	public void setIsBad(Boolean isBad) {
		this.isBad = isBad;
	}

	public void setProtocol(Protocol protocol) {
		this.protocol = protocol;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Segment::[");
		buf.append(segmentKey.toString());
		buf.append(",timeStamp=").append(timeStamp);
		buf.append("\n").append(protocol);
		buf.append(']');
		return buf.toString();
	}

}
