package caslayout.ui.db;

import java.io.Serializable;

/**
 * @author I. Burak Ozyurt
 * @version $Id: SegmentKey.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class SegmentKey implements Serializable {
    private static final long serialVersionUID = 1L;
	private Long visitID;
    private Long experimentID;
    private String subjectID;
    private Long segmentID;
    
    public SegmentKey() {}
    
	public SegmentKey(Long visitID, Long experimentID, String subjectID,
			Long segmentID) {
		super();
		this.visitID = visitID;
		this.experimentID = experimentID;
		this.subjectID = subjectID;
		this.segmentID = segmentID;
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((experimentID == null) ? 0 : experimentID.hashCode());
		result = prime * result
				+ ((segmentID == null) ? 0 : segmentID.hashCode());
		result = prime * result
				+ ((subjectID == null) ? 0 : subjectID.hashCode());
		result = prime * result + ((visitID == null) ? 0 : visitID.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final SegmentKey other = (SegmentKey) obj;
		if (experimentID == null) {
			if (other.experimentID != null)
				return false;
		} else if (!experimentID.equals(other.experimentID))
			return false;
		if (segmentID == null) {
			if (other.segmentID != null)
				return false;
		} else if (!segmentID.equals(other.segmentID))
			return false;
		if (subjectID == null) {
			if (other.subjectID != null)
				return false;
		} else if (!subjectID.equals(other.subjectID))
			return false;
		if (visitID == null) {
			if (other.visitID != null)
				return false;
		} else if (!visitID.equals(other.visitID))
			return false;
		return true;
	}

	/**
	 * @hibernate.property column="componentid" 
	 * @return
	 */
	public Long getVisitID() {
		return visitID;
	}

	/**
	 * @hibernate.property column="nc_experiment_uniqueid" 
	 * @return
	 */
	public Long getExperimentID() {
		return experimentID;
	}

	/**
	 * @hibernate.property column="subjectid" length="64"
	 * @return
	 */
	public String getSubjectID() {
		return subjectID;
	}

	/**
	 * @hibernate.property column="segmentid" 
	 * @return
	 */
	public Long getSegmentID() {
		return segmentID;
	}
	
	public void setVisitID(Long visitID) {
		this.visitID = visitID;
	}

	public void setExperimentID(Long experimentID) {
		this.experimentID = experimentID;
	}

	public void setSubjectID(String subjectID) {
		this.subjectID = subjectID;
	}

	public void setSegmentID(Long segmentID) {
		this.segmentID = segmentID;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("SegmentKey::[");
		buf.append("visitID=").append(visitID);
		buf.append(",experimentID=").append(experimentID);
		buf.append(",subjectID=").append(subjectID);
		buf.append(",segmentID=").append(segmentID);
		buf.append(']');
		return buf.toString();
	}
    
}
