package caslayout.ui.db;

import java.math.BigDecimal;
import java.math.BigInteger;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

import caslayout.Constants;
import caslayout.ui.CALMConfig;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SessionFactoryFactory.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class SessionFactoryFactory {
	protected static SessionFactory sessionFactory = null;

	public synchronized static SessionFactory getSessionFactory(CALMConfig config) {
		String dbType = config.getDbType();
		if (dbType.equals(Constants.ORACLE)) {
			if (sessionFactory == null) {
				Configuration cfg = new Configuration().configure(
				"calm-oracle.cfg.xml");
				if ( !config.isNoPassword() && config.getPwd() != null) {
					cfg.setProperty("hibernate.connection.password", config.getPwd());
				}
				sessionFactory = cfg.buildSessionFactory();
				config.setUser( cfg.getProperty("hibernate.connection.user") );
			}
		} else if (dbType.equals(Constants.POSTGRES)) {
			if (sessionFactory == null) {
				Configuration cfg = new Configuration().configure(
				  "calm-postgres.cfg.xml");
				if ( !config.isNoPassword() && config.getPwd() != null) {
					cfg.setProperty("hibernate.connection.password", config.getPwd());
				}
				sessionFactory = cfg.buildSessionFactory();
				config.setUser( cfg.getProperty("hibernate.connection.user") );
			}			
		}
		
		return sessionFactory;
	}
   
	public synchronized static void shutdown() {
		if ( sessionFactory != null) {
			sessionFactory.close();
		}
	}
	
	public static Long getNextSequenceNumber(String dbType, Session session) {
		Object o = null;
		if (dbType.equals(Constants.ORACLE)) {
		    o = session.createSQLQuery("select uid_seq.nextval from dual").uniqueResult(); 	
		} else if (dbType.equals(Constants.POSTGRES)) {
			o = session.createSQLQuery("select nextval('uid_seq')").uniqueResult();
		} else {
			return null;
		}
		if ( o instanceof BigDecimal ) {
			return new Long( ((BigDecimal) o).longValue() );
		} else {
			return new Long( ((BigInteger) o).longValue() );
		}
	}
}
