package caslayout.ui.db;

/**
 * @hibernate.class table="nc_site"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Site.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class Site extends AbstractVO {
	protected Long uniqueID;
	protected String siteID;
	protected String siteName;
	protected Boolean isPrimary;
	protected String databaseAddress;
	protected String databaseName;
	protected String databaseVendor;
	protected String databaseVersion;
	protected Long databasePort;
	protected String contactFirstName;
	protected String contactLastName;
	protected String contactEmail;
	protected String contactPhone;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="siteid" length="64" not-null="true"
	 * @return
	 */
	public String getSiteID() {
		return siteID;
	}

	/**
	 * @hibernate.property column="sitename" length="64" not-null="true"
	 * @return
	 */
	public String getSiteName() {
		return siteName;
	}

	/**
	 * @hibernate.property column="isprimary" not-null="true"
	 * @return
	 */
	public Boolean getIsPrimary() {
		return isPrimary;
	}

	/**
	 * @hibernate.property column="databaseaddress" length="2048" not-null="true"
	 * @return
	 */
	public String getDatabaseAddress() {
		return databaseAddress;
	}

	/**
	 * @hibernate.property column="databasename" length="64" not-null="true"
	 * @return
	 */
	public String getDatabaseName() {
		return databaseName;
	}

	/**
	 * @hibernate.property column="databasevendor" length="64" not-null="true"
	 * @return
	 */
	public String getDatabaseVendor() {
		return databaseVendor;
	}

	/**
	 * @hibernate.property column="databaseversion" length="64" not-null="true"
	 * @return
	 */
	public String getDatabaseVersion() {
		return databaseVersion;
	}

	/**
	 * @hibernate.property column="databaseport" not-null="true"
	 * @return
	 */
	public Long getDatabasePort() {
		return databasePort;
	}

	/**
	 * @hibernate.property column="contactfirstname" length="64" not-null="true"
	 * @return
	 */
	public String getContactFirstName() {
		return contactFirstName;
	}

	/**
	 * @hibernate.property column="contactlastname" length="64" not-null="true"
	 * @return
	 */
	public String getContactLastName() {
		return contactLastName;
	}

	/**
	 * @hibernate.property column="contactemail" length="128" not-null="true"
	 * @return
	 */
	public String getContactEmail() {
		return contactEmail;
	}

	/**
	 * @hibernate.property column="contactphone" length="128" not-null="true"
	 * @return
	 */
	public String getContactPhone() {
		return contactPhone;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setSiteID(String siteID) {
		this.siteID = siteID;
	}

	public void setSiteName(String siteName) {
		this.siteName = siteName;
	}

	public void setIsPrimary(Boolean isPrimary) {
		this.isPrimary = isPrimary;
	}

	public void setDatabaseAddress(String databaseAddress) {
		this.databaseAddress = databaseAddress;
	}

	public void setDatabaseName(String databaseName) {
		this.databaseName = databaseName;
	}

	public void setDatabaseVendor(String databaseVendor) {
		this.databaseVendor = databaseVendor;
	}

	public void setDatabaseVersion(String databaseVersion) {
		this.databaseVersion = databaseVersion;
	}

	public void setDatabasePort(Long databasePort) {
		this.databasePort = databasePort;
	}

	public void setContactFirstName(String contactFirstName) {
		this.contactFirstName = contactFirstName;
	}

	public void setContactLastName(String contactLastName) {
		this.contactLastName = contactLastName;
	}

	public void setContactEmail(String contactEmail) {
		this.contactEmail = contactEmail;
	}

	public void setContactPhone(String contactPhone) {
		this.contactPhone = contactPhone;
	}
	
	
}
