package caslayout.ui.db;

/**
 * @hibernate.class table="nc_storedassessment"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StoredAssessment.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class StoredAssessment extends AbstractVO {
	protected Long uniqueID;
	protected Long assessmentID;
	protected Long visitID;
	protected Long experimentID;
	protected Long segmentID;
	protected String subjectID;
	protected java.sql.Timestamp timeStamp;
	protected String informantID;
	protected AssessmentInformant informantRelation;
	protected Boolean isValidated;
	protected AssessmentStatus status;
	protected String ratorQuality;
	protected Boolean isTimeinterval;
	protected Float timeinterval;

	/**
	 * @hibernate.property column="assessmentid" not-null="true"
	 */
	public Long getAssessmentID() {
		return assessmentID;
	}

	/**
	 * @hibernate.property column="componentid" not-null="true"
	 * @return
	 */
	public Long getVisitID() {
		return visitID;
	}

	/**
	 * @hibernate.property column="nc_experiment_uniqueid" not-null="true"
	 * @return
	 */
	public Long getExperimentID() {
		return experimentID;
	}

	/**
	 * @hibernate.property column="informantid" length="64"
	 * @return
	 */
	public String getInformantID() {
		return informantID;
	}

	/**
	 * @hibernate.many-to-one column="informantrelation" 
	 * class="caslayout.ui.db.AssessmentInformant"
	 * not-null="true"
	 * @return
	 */
	public AssessmentInformant getInformantRelation() {
		return informantRelation;
	}

	/**
	 * @hibernate.property column="istimeinterval" not-null="true"
	 * @return
	 */
	public Boolean getIsTimeinterval() {
		return isTimeinterval;
	}

	/**
	 * @hibernate.property column="isvalidated" not-null="true"
	 * @return
	 */
	public Boolean getIsValidated() {
		return isValidated;
	}

	/**
	 * @hibernate.property column="ratorQuality" length="128"
	 * @return
	 */
	public String getRatorQuality() {
		return ratorQuality;
	}

	/**
	 * @hibernate.property column="segmentid" not-null="true"
	 * @return
	 */
	public Long getSegmentID() {
		return segmentID;
	}

	/**
	 * @hibernate.many-to-one column="status" 
	 * class="caslayout.ui.db.AssessmentStatus"
	 *  not-null="true"
	 * @return
	 */
	public AssessmentStatus getStatus() {
		return status;
	}

	/**
	 * @hibernate.property column="subjectid" length="64" not-null="true"
	 */
	public String getSubjectID() {
		return subjectID;
	}

	/**
	 * @hibernate.property column="timeinterval"
	 * @return
	 */
	public Float getTimeinterval() {
		return timeinterval;
	}

	/**
	 * @hibernate.property column="time_stamp" type="timestamp"  not-null="true"
	 * @return
	 */
	public java.sql.Timestamp getTimeStamp() {
		return timeStamp;
	}

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	public void setAssessmentID(Long assessmentID) {
		this.assessmentID = assessmentID;
	}

	public void setVisitID(Long componentID) {
		this.visitID = componentID;
	}

	public void setExperimentID(Long experimentUniqueID) {
		this.experimentID = experimentUniqueID;
	}

	public void setInformantID(String informantID) {
		this.informantID = informantID;
	}

	public void setInformantRelation(AssessmentInformant informantRelation) {
		this.informantRelation = informantRelation;
	}

	public void setIsTimeinterval(Boolean isTimeinterval) {
		this.isTimeinterval = isTimeinterval;
	}

	public void setIsValidated(Boolean isValidated) {
		this.isValidated = isValidated;
	}

	public void setRatorQuality(String ratorquality) {
		this.ratorQuality = ratorquality;
	}

	public void setSegmentID(Long segmentID) {
		this.segmentID = segmentID;
	}

	public void setStatus(AssessmentStatus status) {
		this.status = status;
	}

	public void setSubjectID(String subjectID) {
		this.subjectID = subjectID;
	}

	public void setTimeinterval(Float timeinterval) {
		this.timeinterval = timeinterval;
	}

	public void setTimeStamp(java.sql.Timestamp timeStamp) {
		this.timeStamp = timeStamp;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("StoredAssessment::[");
	    buf.append("uniqueID=").append(uniqueID);	
	    buf.append(",assessmentID=").append(assessmentID);
	    buf.append(",experimentID=").append(experimentID);
	    buf.append(",subjectID=").append(subjectID);
		buf.append(']');
		return buf.toString();
	}

}
