package caslayout.ui.db;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * @hibernate.class table="nc_expstudy"
 *
 * @author I. Burak Ozyurt
 * @version $Id: Study.java,v 1.3 2008/10/13 23:58:08 bozyurt Exp $
 */
public class Study extends AbstractVO {
  protected StudyKey studyKey;
	protected Long uniqueID;
	protected Timestamp timeStamp;
	protected String description;
	protected String name;
	protected Float timeInterval;
	protected Boolean isTimeInterval;
	protected Set<Segment> segments = new LinkedHashSet<Segment>(3);


	/**
	 * @hibernate.id generator-class="assigned"
	 * @return
	 */
	public StudyKey getStudyKey() {
		return studyKey;
	}

	public void setStudyKey(StudyKey studyKey) {
		this.studyKey = studyKey;
	}

	/**
	 * @hibernate.property column="uniqueid" not-null="true"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="time_stamp" not-null="true"
	 * @return
	 */
	public Timestamp getTimeStamp() {
		return timeStamp;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @hibernate.property column="name" length="128"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="timeinterval"
	 * @return
	 */
	public Float getTimeInterval() {
		return timeInterval;
	}

	/**
	 * @hibernate.property column="istimeinterval" not-null="true"
	 * @return
	 */
	public Boolean getIsTimeInterval() {
		return isTimeInterval;
	}

	public Set<Segment> getSegments() {
		return segments;
	}



	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setTimeStamp(Timestamp timeStamp) {
		this.timeStamp = timeStamp;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setTimeInterval(Float timeInterval) {
		this.timeInterval = timeInterval;
	}

	public void setIsTimeInterval(Boolean isTimeInterval) {
		this.isTimeInterval = isTimeInterval;
	}

	public void setSegments(Set<Segment> segments) {
		this.segments = segments;
	}

	public void addSegment(Segment segment) {
		segments.add(segment);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Study::[");
		buf.append(studyKey.toString());
		buf.append(",name=").append(name);
		buf.append(",timeStamp=").append(timeStamp);
		for (Iterator<Segment> it = segments.iterator(); it.hasNext();) {
			Segment segment = it.next();
			buf.append("\n").append(segment.toString());
		}
		buf.append(']');
		return buf.toString();
	}


}
