package caslayout.ui.db;

import java.io.Serializable;

/**
 * @author I. Burak Ozyurt
 * @version $Id: StudyKey.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class StudyKey implements Serializable {
	private static final long serialVersionUID = 1L;
	private Long visitID;
	private Long experimentID;
	private String subjectID;
	private Long studyID;

	public StudyKey() {
	}

	public StudyKey(Long visitID, Long experimentID, String subjectID,
			Long studyID) {
		super();
		this.visitID = visitID;
		this.experimentID = experimentID;
		this.subjectID = subjectID;
		this.studyID = studyID;
	}

	/**
	 * @hibernate.property column="componentid" 
	 * @return
	 */
	public Long getVisitID() {
		return visitID;
	}

	/**
	 * @hibernate.property column="experimentid"
	 * @return
	 */
	public Long getExperimentID() {
		return experimentID;
	}

	/**
	 * @hibernate.property column="subjectid" length="64"
	 * @return
	 */
	public String getSubjectID() {
		return subjectID;
	}

	/**
	 * @hibernate.property column="studyid"
	 * @return
	 */
	public Long getStudyID() {
		return studyID;
	}

	public void setVisitID(Long visitID) {
		this.visitID = visitID;
	}

	public void setExperimentID(Long experimentID) {
		this.experimentID = experimentID;
	}

	public void setSubjectID(String subjectID) {
		this.subjectID = subjectID;
	}

	public void setStudyID(Long studyID) {
		this.studyID = studyID;
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((experimentID == null) ? 0 : experimentID.hashCode());
		result = prime * result + ((studyID == null) ? 0 : studyID.hashCode());
		result = prime * result
				+ ((subjectID == null) ? 0 : subjectID.hashCode());
		result = prime * result + ((visitID == null) ? 0 : visitID.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final StudyKey other = (StudyKey) obj;
		if (experimentID == null) {
			if (other.experimentID != null)
				return false;
		} else if (!experimentID.equals(other.experimentID))
			return false;
		if (studyID == null) {
			if (other.studyID != null)
				return false;
		} else if (!studyID.equals(other.studyID))
			return false;
		if (subjectID == null) {
			if (other.subjectID != null)
				return false;
		} else if (!subjectID.equals(other.subjectID))
			return false;
		if (visitID == null) {
			if (other.visitID != null)
				return false;
		} else if (!visitID.equals(other.visitID))
			return false;
		return true;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("StudyKey::[");
		buf.append("visitID=").append(visitID);
		buf.append(",experimentID=").append(experimentID);
		buf.append(",subjectID=").append(subjectID);
		buf.append(",studyID=").append(studyID);
		buf.append(']');
		return buf.toString();
	}
}
