package caslayout.ui.db;

/**
 * @hibernate.class table="nc_subjexperiment"
 * @author I. Burak Ozyurt
 * @version $Id: SubjExperiment.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class SubjExperiment extends AbstractVO {
	protected Long uniqueID;
	protected String subjectID;
	protected Experiment experiment;
	protected ResearchGroup researchGroup;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence" 
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="subjectid" length="64" not-null="true"
	 * @return
	 */
	public String getSubjectID() {
		return subjectID;
	}

	/**
	 * @hibernate.many-to-one column="nc_experiment_uniqueid"
	 * class="caslayout.ui.db.Experiment" 
	 * not-null="true" outer-join="true"
	 * @return
	 */
	public Experiment getExperiment() {
		return experiment;
	}

	/**
	 * @hibernate.many-to-one column="nc_researchgroup_uniqueid"
	 * class="caslayout.ui.db.ResearchGroup"
	 * not-null="true" outer-join="true"
	 * @return
	 */
	public ResearchGroup getResearchGroup() {
		return researchGroup;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setSubjectID(String subjectID) {
		this.subjectID = subjectID;
	}

	public void setExperiment(Experiment experiment) {
		this.experiment = experiment;
	}

	public void setResearchGroup(ResearchGroup researchGroup) {
		this.researchGroup = researchGroup;
	}

}
